/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.tweaker;

import customskinloader.tweaker.ModSystemTweaker;
import customskinloader.utils.MinecraftUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.commons.io.IOUtils;

public class ClassTransformer
implements IClassTransformer {
    private ZipFile zipFile = null;
    private ArrayList<String> classes = new ArrayList();

    public ClassTransformer() {
        ModSystemTweaker.logger.info("ClassTransformer Begin");
        try {
            URL[] urls;
            URLClassLoader ucl = (URLClassLoader)this.getClass().getClassLoader();
            for (URL url : urls = ucl.getURLs()) {
                if (MinecraftUtil.isCoreFile(url)) {
                    ModSystemTweaker.logger.info(url.toString() + " : SKIP (core file).");
                    continue;
                }
                if (MinecraftUtil.isLibraryFile(url)) {
                    ModSystemTweaker.logger.info(url.toString() + " : SKIP (library file).");
                    continue;
                }
                File file = new File(url.toURI());
                if (file == null || !file.isFile()) {
                    ModSystemTweaker.logger.info(url.toString() + " : EXCEPTION (file not found).");
                    continue;
                }
                ZipFile tempZipFile = ClassTransformer.getZipFile(file);
                if (tempZipFile == null) {
                    ModSystemTweaker.logger.info(url.toString() + " : EXCEPTION (^ Message ^).");
                    continue;
                }
                if (tempZipFile.getEntry("customskinloader/tweaker/ClassTransformer.class") == null) {
                    tempZipFile.close();
                    ModSystemTweaker.logger.info(url.toString() + " : FINISH (not target).");
                    continue;
                }
                this.zipFile = tempZipFile;
                Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
                StringBuilder sb = new StringBuilder();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class") || name.contains("/") && !name.startsWith("net")) continue;
                    this.classes.add(name);
                    sb.append(" ");
                    sb.append(name);
                }
                ModSystemTweaker.logger.info(url.toString() + " : CHOOSE.");
                ModSystemTweaker.logger.info("Classes:" + sb.toString());
                break;
            }
        }
        catch (Exception e) {
            ModSystemTweaker.logger.warning(e);
        }
        if (this.zipFile == null) {
            ModSystemTweaker.logger.info("Can not find JAR in the classpath.");
        }
    }

    private static ZipFile getZipFile(File file) {
        ZipFile zipFile0 = null;
        try {
            zipFile0 = new ZipFile(file);
            return zipFile0;
        }
        catch (Exception e) {
            ModSystemTweaker.logger.warning(e);
            return null;
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (this.zipFile == null) {
            return bytes;
        }
        String fullName = (name.startsWith("net") ? name.replaceAll("\\.", "\\/") : name) + ".class";
        if (!this.classes.contains(fullName)) {
            return bytes;
        }
        ZipEntry ze = this.zipFile.getEntry(fullName);
        if (ze == null) {
            return bytes;
        }
        byte[] diBytes = this.getClass(ze);
        if (diBytes != null) {
            ModSystemTweaker.logger.info("Class '" + name + "'(" + transformedName + ") transformed.");
            return diBytes;
        }
        return bytes;
    }

    private byte[] getClass(ZipEntry ze) {
        try {
            InputStream is = this.zipFile.getInputStream(ze);
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            if ((long)bytes.length == ze.getSize()) {
                return bytes;
            }
            ModSystemTweaker.logger.info("Failed: " + ze.getName() + " " + bytes.length + " / " + ze.getSize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

