/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.profile;

import customskinloader.CustomSkinLoader;
import customskinloader.profile.CachedProfile;
import customskinloader.profile.UserProfile;
import customskinloader.utils.TimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class ProfileCache {
    public static File PROFILE_CACHE_DIR = new File(CustomSkinLoader.DATA_DIR, "ProfileCache");
    private HashMap<String, CachedProfile> cachedProfiles = new HashMap();
    private HashMap<String, UserProfile> localProfiles = new HashMap();

    public ProfileCache() {
        if (!PROFILE_CACHE_DIR.exists()) {
            PROFILE_CACHE_DIR.mkdir();
        }
    }

    public boolean isExist(String username) {
        return this.cachedProfiles.containsKey(username.toLowerCase());
    }

    public boolean isReady(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        return cp == null ? false : cp.loading || cp.expiryTime > TimeUtil.getCurrentUnixTimestamp();
    }

    public boolean isExpired(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        return cp == null ? true : cp.expiryTime <= TimeUtil.getCurrentUnixTimestamp();
    }

    public UserProfile getProfile(String username) {
        return this.getCachedProfile((String)username).profile;
    }

    public long getExpiry(String username) {
        return this.getCachedProfile((String)username).expiryTime;
    }

    public UserProfile getLocalProfile(String username) {
        if (this.localProfiles.containsKey(username.toLowerCase())) {
            return this.localProfiles.get(username.toLowerCase());
        }
        return this.loadLocalProfile(username);
    }

    public void setLoading(String username, boolean loading) {
        this.getCachedProfile((String)username).loading = loading;
    }

    public void updateCache(String username, UserProfile profile) {
        this.updateCache(username, profile, CustomSkinLoader.config.enableLocalProfileCache);
    }

    public void updateCache(String username, UserProfile profile, boolean saveLocalProfile) {
        CachedProfile cp = this.getCachedProfile(username);
        cp.profile = profile;
        cp.expiryTime = TimeUtil.getUnixTimestampRandomDelay(CustomSkinLoader.config.cacheExpiry);
        if (!saveLocalProfile) {
            return;
        }
        this.saveLocalProfile(username, profile);
    }

    private CachedProfile getCachedProfile(String username) {
        CachedProfile cp = this.cachedProfiles.get(username.toLowerCase());
        if (cp != null) {
            return cp;
        }
        cp = new CachedProfile();
        this.cachedProfiles.put(username.toLowerCase(), cp);
        return cp;
    }

    private UserProfile loadLocalProfile(String username) {
        File localProfile = new File(PROFILE_CACHE_DIR, username.toLowerCase() + ".json");
        if (!localProfile.exists()) {
            this.localProfiles.put(username.toLowerCase(), null);
        }
        try {
            String json = IOUtils.toString((InputStream)new FileInputStream(localProfile));
            UserProfile profile = (UserProfile)CustomSkinLoader.GSON.fromJson(json, UserProfile.class);
            this.localProfiles.put(username.toLowerCase(), profile);
            CustomSkinLoader.logger.info("Successfully load LocalProfile.");
            return profile;
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to load LocalProfile.(" + e.toString() + ")");
            this.localProfiles.put(username.toLowerCase(), null);
            return null;
        }
    }

    private void saveLocalProfile(String username, UserProfile profile) {
        String json = CustomSkinLoader.GSON.toJson((Object)profile);
        File localProfile = new File(PROFILE_CACHE_DIR, username.toLowerCase() + ".json");
        if (localProfile.exists()) {
            localProfile.delete();
        }
        try {
            localProfile.createNewFile();
            IOUtils.write((String)json, (OutputStream)new FileOutputStream(localProfile));
            CustomSkinLoader.logger.info("Successfully save LocalProfile.");
        }
        catch (Exception e) {
            CustomSkinLoader.logger.info("Failed to save LocalProfile.(" + e.toString() + ")");
        }
    }
}

