/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MojangAPILoader
implements ProfileLoader.IProfileLoader {
    public static MinecraftSessionService defaultSessionService = null;

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) throws Exception {
        if (defaultSessionService == null) {
            CustomSkinLoader.logger.warning("Session Service Not Exist.");
            return null;
        }
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = MojangAPILoader.getTextures(gameProfile);
        if (!map.isEmpty()) {
            CustomSkinLoader.logger.info("Default profile will be used.");
            return ModelManager0.toUserProfile(map);
        }
        String username = gameProfile.getName();
        GameProfile newGameProfile = MojangAPILoader.loadGameProfile(username);
        if (newGameProfile == null) {
            CustomSkinLoader.logger.info("Profile not found.(" + username + "'s profile not found.)");
            return null;
        }
        map = MojangAPILoader.getTextures(newGameProfile = defaultSessionService.fillProfileProperties(newGameProfile, false));
        if (!map.isEmpty()) {
            gameProfile.getProperties().putAll((Multimap)newGameProfile.getProperties());
            return ModelManager0.toUserProfile(map);
        }
        CustomSkinLoader.logger.info("Profile not found.(" + username + " doesn't have skin/cape.)");
        return null;
    }

    public static GameProfile loadGameProfile(String username) throws Exception {
        HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest("https://api.mojang.com/users/profiles/minecraft/" + username).setCacheTime(0));
        if (StringUtils.isEmpty((CharSequence)responce.content)) {
            return null;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
        GameProfile gameProfile = (GameProfile)gson.fromJson(responce.content, GameProfile.class);
        if (gameProfile.getId() == null) {
            return null;
        }
        return new GameProfile(gameProfile.getId(), gameProfile.getName());
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile gameProfile) throws Exception {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        String value = textureProperty.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        String json = new String(Base64.decodeBase64((String)value), Charsets.UTF_8);
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
        MinecraftTexturesPayload result = (MinecraftTexturesPayload)gson.fromJson(json, MinecraftTexturesPayload.class);
        if (result == null || result.getTextures() == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        return result.getTextures();
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return true;
    }

    @Override
    public String getName() {
        return "MojangAPI";
    }

    @Override
    public void initLocalFolder(SkinSiteProfile ssp) {
    }
}

