/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.mojang.authlib.GameProfile;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.loader.jsonapi.CustomSkinAPI;
import customskinloader.loader.jsonapi.CustomSkinAPIPlus;
import customskinloader.loader.jsonapi.UniSkinAPI;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.HttpUtil0;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class JsonAPILoader
implements ProfileLoader.IProfileLoader {
    private Type type;

    public JsonAPILoader(Type type) {
        this.type = type;
    }

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) throws Exception {
        String json;
        String username = gameProfile.getName();
        boolean local = HttpUtil0.isLocal(ssp.root);
        if (ssp.root == null || ssp.root.equals("")) {
            CustomSkinLoader.logger.info("Root not defined.");
            return null;
        }
        String jsonUrl = this.type.jsonAPI.toJsonUrl(ssp.root, username);
        if (local) {
            File jsonFile = new File(jsonUrl);
            if (!jsonFile.exists()) {
                CustomSkinLoader.logger.info("Profile File not found.");
                return null;
            }
            json = IOUtils.toString((InputStream)new FileInputStream(jsonFile));
        } else {
            HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest(jsonUrl).setCacheTime(60).setUserAgent(ssp.userAgent).setPayload(this.type.jsonAPI.getPayload(ssp)));
            json = responce.content;
        }
        if (json == null || json.equals("")) {
            CustomSkinLoader.logger.info("Profile not found.");
            return null;
        }
        ErrorProfile profile = (ErrorProfile)CustomSkinLoader.GSON.fromJson(json, ErrorProfile.class);
        if (profile.errno != 0) {
            CustomSkinLoader.logger.info("Error " + profile.errno + ": " + profile.msg);
            return null;
        }
        UserProfile p = this.type.jsonAPI.toUserProfile(ssp.root, json, local);
        if (p == null || p.isEmpty()) {
            CustomSkinLoader.logger.info("Both skin and cape not found.");
            return null;
        }
        return p;
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{ssp0.root}) ? ssp0.root.equalsIgnoreCase(ssp1.root) : true;
    }

    @Override
    public String getName() {
        return this.type.jsonAPI.getName();
    }

    @Override
    public void initLocalFolder(SkinSiteProfile ssp) {
        File f;
        if (HttpUtil0.isLocal(ssp.root) && !(f = new File(ssp.root)).exists()) {
            f.mkdirs();
        }
    }

    public static enum Type {
        CustomSkinAPI(new CustomSkinAPI()),
        CustomSkinAPIPlus(new CustomSkinAPIPlus()),
        UniSkinAPI(new UniSkinAPI());

        public IJsonAPI jsonAPI;

        private Type(IJsonAPI jsonAPI) {
            this.jsonAPI = jsonAPI;
        }
    }

    public static class ErrorProfile {
        public int errno;
        public String msg;
    }

    public static interface IJsonAPI {
        public String toJsonUrl(String var1, String var2);

        public String getPayload(SkinSiteProfile var1);

        public UserProfile toUserProfile(String var1, String var2, boolean var3);

        public String getName();
    }
}

