/*
 * Decompiled with CFR 0.152.
 */
package customskinloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.Logger;
import customskinloader.config.Config;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.DynamicSkullManager;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.ProfileCache;
import customskinloader.profile.UserProfile;
import customskinloader.utils.MinecraftUtil;
import java.io.File;
import java.util.Map;

public class CustomSkinLoader {
    public static final String CustomSkinLoader_VERSION = "14.6";
    public static final String CustomSkinLoader_FULL_VERSION = "14.6a";
    public static final File DATA_DIR = new File(MinecraftUtil.getMinecraftDataDir0(), "CustomSkinLoader");
    public static final File LOG_FILE = new File(DATA_DIR, "CustomSkinLoader.log");
    public static final File CONFIG_FILE = new File(DATA_DIR, "CustomSkinLoader.json");
    public static final SkinSiteProfile[] DEFAULT_LOAD_LIST = new SkinSiteProfile[]{SkinSiteProfile.createMojangAPI("Mojang"), SkinSiteProfile.createCustomSkinAPI("BlessingSkin", "http://skin.prinzeugen.net/"), SkinSiteProfile.createCustomSkinAPI("OneSkin", "http://fleey.org/skin/skin_user/skin_json.php/"), SkinSiteProfile.createUniSkinAPI("SkinMe", "http://www.skinme.cc/uniskin/"), SkinSiteProfile.createLegacy("LocalSkin", "LocalSkin/skins/{USERNAME}.png", "LocalSkin/capes/{USERNAME}.png", "LocalSkin/elytras/{USERNAME}.png")};
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger logger = CustomSkinLoader.initLogger();
    public static final Config config = Config.loadConfig0();
    private static final ProfileCache profileCache = new ProfileCache();
    private static final DynamicSkullManager dynamicSkullManager = new DynamicSkullManager();

    public static Map loadProfile(GameProfile gameProfile) {
        String username = gameProfile.getName();
        if (username == null) {
            logger.warning("Could not load profile: username is null.");
            return Maps.newHashMap();
        }
        String tempName = Thread.currentThread().getName();
        Thread.currentThread().setName(username);
        UserProfile profile = null;
        if (profileCache.isReady(username)) {
            logger.info("Cached profile will be used.");
            profile = profileCache.getProfile(username);
            if (profile == null) {
                logger.warning("(!Cached Profile is empty!) Expiry:" + profileCache.getExpiry(username));
                if (profileCache.isExpired(username)) {
                    profile = CustomSkinLoader.loadProfile0(gameProfile);
                }
            } else {
                logger.info(profile.toString(profileCache.getExpiry(username)));
            }
        } else {
            profileCache.setLoading(username, true);
            profile = CustomSkinLoader.loadProfile0(gameProfile);
        }
        Thread.currentThread().setName(tempName);
        return ModelManager0.fromUserProfile(profile);
    }

    public static UserProfile loadProfile0(GameProfile gameProfile) {
        String username = gameProfile.getName();
        profileCache.setLoading(username, true);
        logger.info("Loading " + username + "'s profile.");
        if (CustomSkinLoader.config.loadlist == null || CustomSkinLoader.config.loadlist.isEmpty()) {
            logger.info("LoadList is Empty.");
            return null;
        }
        for (int i = 0; i < CustomSkinLoader.config.loadlist.size(); ++i) {
            SkinSiteProfile ssp = CustomSkinLoader.config.loadlist.get(i);
            logger.info(i + 1 + "/" + CustomSkinLoader.config.loadlist.size() + " Try to load profile from '" + ssp.name + "'.");
            ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
            if (loader == null) {
                logger.info("Type '" + ssp.type + "' is not defined.");
                continue;
            }
            UserProfile profile = null;
            try {
                profile = loader.loadProfile(ssp, gameProfile);
            }
            catch (Exception e) {
                logger.warning("Exception occurs while loading.");
                logger.warning(e);
            }
            if (profile == null) continue;
            logger.info(username + "'s profile loaded.");
            profileCache.updateCache(username, profile);
            profileCache.setLoading(username, false);
            logger.info(profile.toString(profileCache.getExpiry(username)));
            return profile;
        }
        logger.info(username + "'s profile not found in load list.");
        if (CustomSkinLoader.config.enableLocalProfileCache) {
            UserProfile profile = profileCache.getLocalProfile(username);
            if (profile == null) {
                logger.info(username + "'s LocalProfile not found.");
            } else {
                profileCache.updateCache(username, profile, false);
                profileCache.setLoading(username, false);
                logger.info(username + "'s LocalProfile will be used.");
                logger.info(profile.toString(profileCache.getExpiry(username)));
                return profile;
            }
        }
        profileCache.setLoading(username, false);
        return null;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadProfileFromCache(final GameProfile gameProfile) {
        String username = gameProfile.getName();
        if (username == null) {
            return dynamicSkullManager.getTexture(gameProfile);
        }
        if (CustomSkinLoader.config.enableUpdateSkull ? profileCache.isReady(username) : profileCache.isExist(username)) {
            UserProfile profile = profileCache.getProfile(username);
            return ModelManager0.fromUserProfile(profile);
        }
        Thread loadThread = new Thread(){

            @Override
            public void run() {
                CustomSkinLoader.loadProfile0(gameProfile);
            }
        };
        loadThread.setName(username + "'s skull");
        loadThread.start();
        return Maps.newHashMap();
    }

    private static Logger initLogger() {
        Logger logger = new Logger(LOG_FILE);
        logger.info("CustomSkinLoader 14.6a");
        logger.info("DataDir: " + DATA_DIR.getAbsolutePath());
        logger.info("Minecraft: " + MinecraftUtil.getMinecraftMainVersion() + "(" + MinecraftUtil.getMinecraftVersionText() + ")");
        return logger;
    }
}

