/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.mojang.authlib.GameProfile;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.JsonAPILoader;
import customskinloader.loader.LegacyLoader;
import customskinloader.loader.MojangAPILoader;
import customskinloader.profile.UserProfile;
import java.util.HashMap;

public class ProfileLoader {
    private static final IProfileLoader[] DEFAULT_LOADERS = new IProfileLoader[]{new MojangAPILoader(), new JsonAPILoader(JsonAPILoader.Type.CustomSkinAPI), new JsonAPILoader(JsonAPILoader.Type.CustomSkinAPIPlus), new JsonAPILoader(JsonAPILoader.Type.UniSkinAPI), new JsonAPILoader(JsonAPILoader.Type.ElyByAPI), new LegacyLoader()};
    public static final HashMap<String, IProfileLoader> LOADERS = ProfileLoader.initLoaders();

    private static HashMap<String, IProfileLoader> initLoaders() {
        HashMap<String, IProfileLoader> loaders = new HashMap<String, IProfileLoader>();
        for (IProfileLoader loader : DEFAULT_LOADERS) {
            loaders.put(loader.getName().toLowerCase(), loader);
        }
        return loaders;
    }

    public static interface IProfileLoader {
        public UserProfile loadProfile(SkinSiteProfile var1, GameProfile var2) throws Exception;

        public boolean compare(SkinSiteProfile var1, SkinSiteProfile var2);

        public String getName();

        public void initLocalFolder(SkinSiteProfile var1);
    }
}

