/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.loader;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import customskinloader.CustomSkinLoader;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.UserProfile;
import customskinloader.utils.HttpRequestUtil;
import customskinloader.utils.MinecraftUtil;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class MojangAPILoader
implements ProfileLoader.IProfileLoader {
    public static final MinecraftSessionService defaultSessionService = MinecraftUtil.getSessionService();

    @Override
    public UserProfile loadProfile(SkinSiteProfile ssp, GameProfile gameProfile) throws Exception {
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> map = MojangAPILoader.getTextures(gameProfile);
        if (!map.isEmpty()) {
            CustomSkinLoader.logger.info("Default profile will be used.");
            return ModelManager0.toUserProfile(map);
        }
        String username = gameProfile.getName();
        GameProfile newGameProfile = MojangAPILoader.loadGameProfile(username);
        if (newGameProfile == null) {
            CustomSkinLoader.logger.info("Profile not found.(" + username + "'s profile not found.)");
            return null;
        }
        map = MojangAPILoader.getTextures(newGameProfile = MojangAPILoader.fillGameProfile(newGameProfile));
        if (!map.isEmpty()) {
            gameProfile.getProperties().putAll((Multimap)newGameProfile.getProperties());
            return ModelManager0.toUserProfile(map);
        }
        CustomSkinLoader.logger.info("Profile not found.(" + username + " doesn't have skin/cape.)");
        return null;
    }

    public static GameProfile loadGameProfile(String username) {
        HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest("https://api.mojang.com/users/profiles/minecraft/" + username).setCacheTime(0));
        if (StringUtils.isEmpty((CharSequence)responce.content)) {
            return null;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
        GameProfile gameProfile = (GameProfile)gson.fromJson(responce.content, GameProfile.class);
        if (gameProfile.getId() == null) {
            return null;
        }
        return new GameProfile(gameProfile.getId(), gameProfile.getName());
    }

    public static GameProfile fillGameProfile(GameProfile profile) {
        HttpRequestUtil.HttpResponce responce = HttpRequestUtil.makeHttpRequest(new HttpRequestUtil.HttpRequest("https://sessionserver.mojang.com/session/minecraft/profile/" + UUIDTypeAdapter.fromUUID((UUID)profile.getId())).setCacheTime(90));
        if (StringUtils.isEmpty((CharSequence)responce.content)) {
            return profile;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        MinecraftProfilePropertiesResponse propertiesResponce = (MinecraftProfilePropertiesResponse)gson.fromJson(responce.content, MinecraftProfilePropertiesResponse.class);
        GameProfile newGameProfile = new GameProfile(propertiesResponce.getId(), propertiesResponce.getName());
        newGameProfile.getProperties().putAll((Multimap)propertiesResponce.getProperties());
        return newGameProfile;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile gameProfile) {
        if (gameProfile == null) {
            return Maps.newHashMap();
        }
        Property textureProperty = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return Maps.newHashMap();
        }
        String value = textureProperty.getValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return Maps.newHashMap();
        }
        String json = new String(Base64.decodeBase64((String)value), Charsets.UTF_8);
        Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();
        MinecraftTexturesPayload result = (MinecraftTexturesPayload)gson.fromJson(json, MinecraftTexturesPayload.class);
        if (result == null || result.getTextures() == null) {
            return Maps.newHashMap();
        }
        return result.getTextures();
    }

    @Override
    public boolean compare(SkinSiteProfile ssp0, SkinSiteProfile ssp1) {
        return true;
    }

    @Override
    public String getName() {
        return "MojangAPI";
    }

    @Override
    public void initLocalFolder(SkinSiteProfile ssp) {
    }
}

