/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.placeholders;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;

public class SeasonsPlaceholderExpansion
extends PlaceholderExpansion {
    private final Seasons seasons;

    public SeasonsPlaceholderExpansion(Seasons seasons) {
        this.seasons = seasons;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return "Harieo";
    }

    @NotNull
    public String getIdentifier() {
        return "seasons";
    }

    @NotNull
    public String getVersion() {
        return this.seasons.getPlugin().getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        RequestType type;
        if (player == null) {
            return "";
        }
        if (identifier.startsWith("season")) {
            type = RequestType.SEASON;
        } else if (identifier.startsWith("weather")) {
            type = RequestType.WEATHER;
        } else if (identifier.startsWith("day")) {
            type = RequestType.DAY;
        } else {
            return null;
        }
        return this.makeAttempt(player, identifier, type);
    }

    private String makeAttempt(Player player, String identifier, RequestType type) {
        World world;
        String[] split = identifier.split("_");
        if (split.length < 2) {
            world = player.getWorld();
        } else {
            StringBuilder builder = new StringBuilder();
            for (int i = 1; i < split.length; ++i) {
                builder.append(split[i]);
                if (i + 1 >= split.length) continue;
                builder.append("_");
            }
            String worldName = builder.toString();
            world = Bukkit.getWorld((String)worldName);
        }
        if (world == null) {
            return "Invalid world";
        }
        Cycle cycle = this.seasons.getWorldCycle(world);
        if (cycle == null) {
            return "None";
        }
        if (type == RequestType.SEASON) {
            return cycle.getSeason().getName();
        }
        if (type == RequestType.WEATHER) {
            return cycle.getWeather().getName();
        }
        return String.valueOf(cycle.getDay());
    }

    public static enum RequestType {
        SEASON,
        WEATHER,
        DAY;

    }
}

