/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.bukkit.ChatColor;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.configuration.SeasonsConfig;
import uk.co.harieo.seasons.plugin.configuration.StaticPlaceholders;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.effect.Effect;

public enum Weather {
    BEAUTIFUL("Beautiful", ChatColor.GREEN + "The sun in shining, the grass is green and the weather is " + ChatColor.YELLOW + "Beautiful", false, false, false, 20, Arrays.asList(Season.SPRING, Season.SUMMER)),
    BREEZY("Breezy", ChatColor.GRAY + "A cool breeze touches your skin, it's going to be " + ChatColor.GREEN + "Breezy", false, false, false, 15, Arrays.asList(Season.SPRING, Season.AUTUMN)),
    CHILLY("Chilly", ChatColor.BLUE + "You shiver as frost glistens around you, it's very " + ChatColor.DARK_BLUE + "Chilly " + ChatColor.BLUE + "today", false, false, false, 15, Collections.singletonList(Season.SPRING)),
    RAINY("Rainy", ChatColor.BLUE + "A loud rain falls and wets the ground, it's " + ChatColor.DARK_BLUE + "Rainy", false, true, false, 10, Arrays.asList(Season.SPRING, Season.AUTUMN, Season.WINTER)),
    SCORCHING("Scorching", ChatColor.YELLOW + "The sun burns your skin and the ground hurts to touch, it's " + ChatColor.GOLD + "Scorching", false, false, false, 10, Collections.singletonList(Season.SUMMER)),
    HOT("Hot", ChatColor.YELLOW + "It's going to be very " + ChatColor.GOLD + "Hot " + ChatColor.YELLOW + "today", false, false, false, 20, Collections.singletonList(Season.SUMMER)),
    WARM("Warm", ChatColor.YELLOW + "A soothing warmth hugs you as you move, it's a " + ChatColor.GOLD + "Warm " + ChatColor.YELLOW + "day", false, false, false, 25, Collections.singletonList(Season.SUMMER)),
    COLD("Cold", ChatColor.BLUE + "The water is so very " + ChatColor.DARK_BLUE + "Cold " + ChatColor.BLUE + "today", false, false, false, 40, Arrays.asList(Season.AUTUMN, Season.WINTER)),
    STORMY("Stormy", ChatColor.RED + "A great " + ChatColor.DARK_RED + "Storm " + ChatColor.RED + "brews, the Gods in this place are angry... Brace yourself!", true, true, true, 10, Collections.singletonList(Season.AUTUMN)),
    FREEZING("Freezing", ChatColor.BLUE + "The water freezes with a sheet of ice and you feel a great cold, it's " + ChatColor.DARK_BLUE + "Freezing", true, false, false, 15, Collections.singletonList(Season.WINTER)),
    SNOWY("Snowy", ChatColor.GRAY + "A great white blanket covers the world, it's " + ChatColor.WHITE + "Snowy", false, true, false, 15, Collections.singletonList(Season.WINTER)),
    NIGHT("Calm", ChatColor.GRAY + "The world rests with the sun and all is calm... Until the mobs come to eat you!", false, false, false);

    private static final Random random;
    private final String name;
    private final String message;
    private final boolean catastrophic;
    private final boolean storm;
    private final boolean thundering;
    private final int defaultChance;
    private final List<Season> seasons;

    private Weather(String name, String broadcast, boolean catastrophic, boolean storm, boolean thundering, int defaultChance, List<Season> seasons) {
        this.name = name;
        this.message = broadcast;
        this.catastrophic = catastrophic;
        this.storm = storm;
        this.thundering = thundering;
        this.defaultChance = defaultChance;
        this.seasons = seasons;
    }

    private Weather(String name, String broadcast, boolean catastrophic, boolean storm, boolean thundering) {
        this(name, broadcast, catastrophic, storm, thundering, 0, Collections.emptyList());
    }

    public String getName() {
        return Seasons.getInstance().getLanguageConfig().getString("weathers.name." + this.name().toLowerCase()).orElse(this.name);
    }

    public String getRawName() {
        return ChatColor.stripColor((String)this.getName()).toLowerCase();
    }

    public Optional<String> getMessage() {
        return Seasons.getInstance().getLanguageConfig().getStringOrDefault("weathers.on-trigger." + this.name().toLowerCase(), this.message).map(message -> message.replaceAll(StaticPlaceholders.WEATHER.toString(), this.getName()));
    }

    public boolean isCatastrophic() {
        return this.catastrophic;
    }

    public boolean isStorm() {
        return this.storm;
    }

    public boolean isThundering() {
        return this.thundering;
    }

    public int getDefaultChance() {
        return this.defaultChance;
    }

    public List<Season> getAffectedSeasons() {
        return this.seasons;
    }

    public List<Effect> getEffects() {
        ArrayList<Effect> effects = new ArrayList<Effect>();
        Seasons seasons = Seasons.getInstance();
        for (Effect effect : seasons.getEffects()) {
            if (!effect.isWeatherApplicable(this)) continue;
            effects.add(effect);
        }
        return effects;
    }

    public static Weather fromName(String name) {
        for (Weather weather : Weather.values()) {
            if (!weather.getRawName().equalsIgnoreCase(name)) continue;
            return weather;
        }
        return null;
    }

    public static Weather randomWeather() {
        return Weather.values()[random.nextInt(Weather.values().length)];
    }

    public static Weather randomWeather(Season season) {
        HashSet<Weather> applicableWeathers = new HashSet<Weather>();
        for (Weather weather : Weather.values()) {
            if (!weather.getAffectedSeasons().contains((Object)season) || Weather.isManuallyDisabled(weather)) continue;
            applicableWeathers.add(weather);
        }
        return Seasons.getInstance().getWeatherChanceConfiguration().pickRandomWeather(applicableWeathers);
    }

    public static boolean isManuallyDisabled(Weather weather) {
        SeasonsConfig config = Seasons.getInstance().getSeasonsConfig();
        for (String weatherName : config.getDisabledWeathers()) {
            if (!weatherName.equalsIgnoreCase(weather.getRawName())) continue;
            return true;
        }
        return false;
    }

    public static List<String> getWeatherList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Weather weather : Weather.values()) {
            list.add(weather.getName());
        }
        return list;
    }

    static {
        random = new Random();
    }
}

