/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.configuration;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.configuration.ConfigurationProvider;
import uk.co.harieo.seasons.plugin.models.Weather;

public class WeatherChanceConfiguration
implements ConfigurationProvider {
    private final Map<Weather, Integer> loadedChances = new HashMap<Weather, Integer>();
    private double currentVersion;

    @Override
    public String getFileName() {
        return "chances.yml";
    }

    @Override
    public boolean load(JavaPlugin plugin) {
        try {
            FileConfiguration configuration = this.getConfiguration(plugin);
            this.currentVersion = configuration.getDouble("version");
            this.loadedChances.clear();
            for (Weather weather : Weather.values()) {
                String key = weather.name().toLowerCase();
                if (configuration.isSet(key)) {
                    this.loadedChances.put(weather, configuration.getInt(key));
                    continue;
                }
                if (weather.getDefaultChance() <= 0) continue;
                configuration.set(key, (Object)weather.getDefaultChance());
            }
            configuration.save(this.getFile(plugin));
            this.verifyVersion();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getChance(Weather weather) {
        return this.loadedChances.getOrDefault((Object)weather, weather.getDefaultChance());
    }

    public Weather pickRandomWeather(Collection<Weather> possibilities) {
        possibilities.removeIf(weather -> weather.getDefaultChance() <= 0);
        int highestBound = 0;
        for (Weather weather2 : possibilities) {
            highestBound += this.getChance(weather2);
        }
        int randomNumber = Seasons.RANDOM.nextInt(highestBound);
        int sum = 0;
        for (Weather weather3 : possibilities) {
            if (randomNumber >= (sum += this.getChance(weather3))) continue;
            return weather3;
        }
        throw new IllegalStateException("Sum of chances did not produce a result");
    }

    @Override
    public double getLatestVersion() {
        return 1.0;
    }

    @Override
    public double getCurrentVersion() {
        return this.currentVersion;
    }
}

