/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.configuration;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;

public class SeasonsWorlds {
    private static final Season DEFAULT_SEASON = Season.SPRING;
    private static final Weather DEFAULT_WEATHER = Weather.BEAUTIFUL;
    private static final String CHILD_DIRECTORY_PATH = "/worlds";
    private final Seasons core;
    private final JavaPlugin plugin;
    private final List<Cycle> cycles;

    public SeasonsWorlds(Seasons core) {
        this.core = core;
        this.plugin = core.getPlugin();
        this.cycles = new ArrayList<Cycle>();
        this.loadAll();
    }

    private void loadAll() {
        List<String> disabledWorlds = this.core.getSeasonsConfig().getDisabledWorlds();
        for (World world : Bukkit.getWorlds()) {
            if (disabledWorlds.contains(world.getName())) continue;
            this.addWorld(world);
        }
    }

    public void addWorld(World world) {
        if (world.getEnvironment() == World.Environment.NORMAL) {
            String worldName = world.getName();
            Logger logger = this.plugin.getLogger();
            Cycle cycle = this.parseWorldSave(world);
            this.cycles.add(cycle);
            world.setStorm(cycle.getWeather().isStorm());
            logger.info("Loaded world '" + worldName + "' into Seasons!");
        }
    }

    public List<Cycle> getParsedCycles() {
        return this.cycles;
    }

    private Cycle createDefaultCycle(World world) {
        return new Cycle(world, DEFAULT_SEASON, world.getTime() > 12400L && world.getTime() < 23850L ? Weather.NIGHT : DEFAULT_WEATHER, 1);
    }

    public boolean saveAllWorlds() {
        boolean errorEncountered = false;
        for (Cycle cycle : this.core.getCycles()) {
            try {
                this.saveWorld(cycle);
            }
            catch (FileAlreadyExistsException e) {
                e.printStackTrace();
                errorEncountered = true;
            }
        }
        return !errorEncountered;
    }

    private File getDefaultDirectory() {
        File file = new File(this.plugin.getDataFolder() + CHILD_DIRECTORY_PATH);
        if (!file.exists() && !file.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create necessary child directories, Seasons will be unable to save files!");
        }
        return file;
    }

    private String getWorldFileName(String worldName) {
        return worldName + ".json";
    }

    private void saveWorld(Cycle cycle) throws FileAlreadyExistsException {
        String worldName = cycle.getWorld().getName();
        String fileName = this.getWorldFileName(worldName);
        File file = new File(this.getDefaultDirectory(), fileName);
        if (file.exists() && !file.delete()) {
            throw new FileAlreadyExistsException("Cannot overwrite file where necessary: " + fileName);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("worldName", worldName);
        jsonObject.addProperty("day", (Number)cycle.getDay());
        jsonObject.addProperty("season", cycle.getSeason().name());
        jsonObject.addProperty("weather", cycle.getWeather().name());
        try (FileWriter writer = new FileWriter(file);){
            writer.write(jsonObject.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isWorldSaved(World world) {
        return new File(this.getDefaultDirectory(), this.getWorldFileName(world.getName())).exists();
    }

    private Cycle parseWorldSave(World world) {
        int day = 1;
        Season season = DEFAULT_SEASON;
        Weather weather = DEFAULT_WEATHER;
        if (this.isWorldSaved(world)) {
            File file = new File(this.getDefaultDirectory(), this.getWorldFileName(world.getName()));
            try (FileReader reader = new FileReader(file);){
                JsonObject jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                day = jsonObject.get("day").getAsInt();
                season = Season.valueOf(jsonObject.get("season").getAsString());
                weather = Weather.valueOf(jsonObject.get("weather").getAsString());
            }
            catch (IOException | IllegalArgumentException e) {
                e.printStackTrace();
                this.plugin.getLogger().severe("World data was invalid in file " + file.getName());
                return this.createDefaultCycle(world);
            }
        }
        return new Cycle(world, season, world.getTime() > 12400L && world.getTime() < 23850L ? Weather.NIGHT : weather, day);
    }
}

