/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.commands;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.commands.SeasonsInfoSubcommand;
import uk.co.harieo.seasons.plugin.configuration.SeasonsLanguageConfiguration;
import uk.co.harieo.seasons.plugin.configuration.StaticPlaceholders;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;

public class SeasonsCommand
implements CommandExecutor {
    private static final String WATERMARK = ChatColor.GOLD + ChatColor.BOLD.toString() + "Seasons " + ChatColor.GRAY + "v" + Seasons.getInstance().getPlugin().getDescription().getVersion() + " made by " + ChatColor.YELLOW + "Harieo";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String s, String[] args) {
        if (!(sender instanceof Player)) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase("reload")) {
                    this.reloadSeasons(sender);
                    return false;
                }
                if (args[0].equalsIgnoreCase("config")) {
                    SeasonsInfoSubcommand.requestConfigurationDetails(sender);
                    return false;
                }
            }
            sender.sendMessage("Only players may use this command!");
            return false;
        }
        Seasons seasons = Seasons.getInstance();
        Player player = (Player)sender;
        Cycle cycle = seasons.getWorldCycle(player.getWorld());
        boolean hasEnabledEffects = seasons.getSeasonsConfig().hasEnabledEffects();
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("import")) {
                this.importWorld(player, player.getWorld());
            } else if (args[0].equalsIgnoreCase("effects")) {
                this.sendEffectsList(player, cycle, hasEnabledEffects);
            } else if (args[0].equalsIgnoreCase("reload")) {
                this.reloadSeasons((CommandSender)player);
            } else if (args[0].equalsIgnoreCase("config")) {
                SeasonsInfoSubcommand.requestConfigurationDetails(sender);
            } else if (args[0].equalsIgnoreCase("list")) {
                this.listAvailableModels(player, args);
            }
        } else {
            player.sendMessage(WATERMARK);
            this.sendSeasonInfo(player, cycle, hasEnabledEffects);
        }
        return false;
    }

    private void reloadSeasons(CommandSender sender) {
        if (!sender.hasPermission("seasons.reload")) {
            SeasonsCommand.sendPermissionDenied(sender);
            return;
        }
        Seasons seasons = Seasons.getInstance();
        JavaPlugin plugin = seasons.getPlugin();
        seasons.getLanguageConfig().load(plugin);
        seasons.getSeasonsConfig().load(plugin);
        seasons.getWeatherChanceConfiguration().load(plugin);
        seasons.setPrefix();
        sender.sendMessage(Seasons.PREFIX + ChatColor.GREEN + "Plugin has been reloaded!");
    }

    private void sendEffectsList(Player player, Cycle cycle, boolean hasEnabledEffects) {
        if (cycle == null) {
            SeasonsCommand.sendBarrenWorldError((CommandSender)player);
            return;
        }
        SeasonsLanguageConfiguration languageConfiguration = Seasons.getInstance().getLanguageConfig();
        if (hasEnabledEffects) {
            Weather weather = cycle.getWeather();
            player.sendMessage("");
            languageConfiguration.getStringOrDefault("command.effects-list-title", ChatColor.GRAY + "For the weather " + ChatColor.YELLOW + weather.getName() + ChatColor.GRAY + " the effects are:").ifPresent(message -> player.sendMessage(Seasons.PREFIX + message.replace(StaticPlaceholders.WEATHER.toString(), weather.getName())));
            Optional<String> potentialEffectsListElement = languageConfiguration.getStringOrDefault("command.effects-list-element", ChatColor.GOLD + ChatColor.BOLD.toString() + "%effect%: " + ChatColor.GRAY + "%description%");
            if (potentialEffectsListElement.isPresent()) {
                String effectsListElement = potentialEffectsListElement.get();
                for (Effect effect : weather.getEffects()) {
                    String effectName = effect.getName();
                    player.sendMessage(effectsListElement.replace("%effect%", effect.isEnabled() ? effectName : ChatColor.RED + ChatColor.BOLD.toString() + effectName).replace("%description%", effect.getDescription()));
                }
            }
            player.sendMessage("");
        } else {
            languageConfiguration.getStringOrDefault("command.all-effects-disabled", ChatColor.RED + "Your administrator has disabled all effects!").ifPresent(message -> player.sendMessage(Seasons.PREFIX + message));
        }
    }

    private void sendSeasonInfo(Player player, Cycle cycle, boolean hasEnabledEffects) {
        if (cycle == null) {
            SeasonsCommand.sendBarrenWorldError((CommandSender)player);
            return;
        }
        Season season = cycle.getSeason();
        player.sendMessage("");
        Seasons seasons = Seasons.getInstance();
        SeasonsLanguageConfiguration languageConfiguration = seasons.getLanguageConfig();
        List<String> seasonInfo = languageConfiguration.getStringList("command.season-info");
        if (seasonInfo != null && !seasonInfo.isEmpty()) {
            seasonInfo.stream().map(string -> {
                String replaced = string.replace(StaticPlaceholders.SEASON_COLOR.toString(), season.getColor().toString());
                replaced = replaced.replace(StaticPlaceholders.SEASON.toString(), season.getName());
                replaced = replaced.replace(StaticPlaceholders.WEATHER.toString(), cycle.getWeather().getName());
                replaced = replaced.replace(StaticPlaceholders.DAY.toString(), String.valueOf(cycle.getDay()));
                replaced = replaced.replace(StaticPlaceholders.MAX_DAYS.toString(), String.valueOf(seasons.getSeasonsConfig().getDaysPerSeason()));
                return replaced;
            }).collect(Collectors.toList()).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
        } else {
            player.sendMessage(season.getColor() + "Your world is in " + season.getName());
            player.sendMessage(ChatColor.GREEN + "The weather is currently " + ChatColor.DARK_GREEN + cycle.getWeather().getName());
            player.sendMessage(ChatColor.GOLD + "Today is day " + cycle.getDay() + " of " + seasons.getSeasonsConfig().getDaysPerSeason());
        }
        if (hasEnabledEffects) {
            languageConfiguration.getStringOrDefault("command.season-info-footer", ChatColor.GRAY + "To see the effects of this weather, use the command " + ChatColor.YELLOW + "/seasons effects").ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
        }
        player.sendMessage("");
    }

    private void importWorld(Player player, World world) {
        if (!player.hasPermission("seasons.import")) {
            SeasonsCommand.sendPermissionDenied((CommandSender)player);
            return;
        }
        Seasons seasons = Seasons.getInstance();
        if (seasons.getWorldCycle(world) != null) {
            player.sendMessage(Seasons.PREFIX + ChatColor.RED + "This world has already been imported!");
        } else if (world.getEnvironment() != World.Environment.NORMAL) {
            player.sendMessage(Seasons.PREFIX + ChatColor.RED + "This world has an invalid environment, Seasons doesn't use NETHER or END worlds");
        } else {
            seasons.getWorldHandler().addWorld(world);
            player.sendMessage(Seasons.PREFIX + ChatColor.GREEN + "Successfully imported world!");
        }
    }

    private void listAvailableModels(Player player, String[] args) {
        SeasonsLanguageConfiguration languageConfiguration = Seasons.getInstance().getLanguageConfig();
        if (args.length == 1) {
            languageConfiguration.getStringList("command.list-help").stream().map(string -> string.replaceAll(StaticPlaceholders.OPTIONS.toString(), "weather, seasons")).forEach(arg_0 -> ((Player)player).sendMessage(arg_0));
        } else {
            String modelName;
            List<String> allModelNames;
            StringBuilder builder = new StringBuilder();
            builder.append(ChatColor.YELLOW);
            if (args[1].equalsIgnoreCase("weather")) {
                allModelNames = Weather.getWeatherList();
                modelName = "Weathers";
            } else if (args[1].equalsIgnoreCase("seasons")) {
                allModelNames = Season.getSeasonsList();
                modelName = "Seasons";
            } else {
                languageConfiguration.getStringOrDefault("list-error", ChatColor.GRAY + "That is not something that is listed").ifPresent(arg_0 -> ((Player)player).sendMessage(arg_0));
                return;
            }
            for (int i = 0; i < allModelNames.size(); ++i) {
                builder.append(allModelNames.get(i));
                if (i + 1 >= allModelNames.size()) continue;
                builder.append(", ");
            }
            player.sendMessage(ChatColor.GRAY + modelName + " available: " + builder.toString());
        }
    }

    public static void sendBarrenWorldError(CommandSender sender) {
        Seasons.getInstance().getLanguageConfig().getStringOrDefault("command.barren-world", ChatColor.RED + "This world is barren and full of darkness... It has no season!").ifPresent(message -> SeasonsCommand.sendWithPrefix(message, sender));
    }

    public static void sendPermissionDenied(CommandSender sender) {
        SeasonsLanguageConfiguration languageConfiguration = Seasons.getInstance().getLanguageConfig();
        languageConfiguration.getStringOrDefault("command.permission-denied", ChatColor.RED + "You do not have permission to do that!").ifPresent(message -> SeasonsCommand.sendWithPrefix(message, sender));
    }

    public static void sendWithPrefix(String message, CommandSender receiver) {
        receiver.sendMessage(Seasons.PREFIX + message);
    }
}

