/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.SeasonalListener;
import uk.co.harieo.seasons.plugin.WorldTicker;
import uk.co.harieo.seasons.plugin.actionbar.TitleMessageHandler;
import uk.co.harieo.seasons.plugin.commands.ChangeCommand;
import uk.co.harieo.seasons.plugin.commands.SeasonsCommand;
import uk.co.harieo.seasons.plugin.configuration.SeasonsConfig;
import uk.co.harieo.seasons.plugin.configuration.SeasonsLanguageConfiguration;
import uk.co.harieo.seasons.plugin.configuration.SeasonsWorlds;
import uk.co.harieo.seasons.plugin.configuration.WeatherChanceConfiguration;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.SeasonsPotionEffect;
import uk.co.harieo.seasons.plugin.placeholders.SeasonsPlaceholderExpansion;

public class Seasons {
    public static String PREFIX;
    public static final Random RANDOM;
    private static Seasons INSTANCE;
    private final SeasonsConfig config;
    private final SeasonsLanguageConfiguration languageConfig;
    private final WeatherChanceConfiguration weatherChanceConfiguration;
    private final JavaPlugin plugin;
    private final List<Effect> effects = new ArrayList<Effect>();
    private SeasonsWorlds worldHandler;

    public Seasons(JavaPlugin plugin) {
        INSTANCE = this;
        this.plugin = plugin;
        Logger logger = plugin.getLogger();
        HashSet<String> fileNameErrors = new HashSet<String>();
        this.config = new SeasonsConfig();
        if (!this.config.load(plugin)) {
            fileNameErrors.add(this.config.getFileName());
        }
        this.languageConfig = new SeasonsLanguageConfiguration();
        if (!this.languageConfig.load(plugin)) {
            fileNameErrors.add(this.languageConfig.getFileName());
        }
        this.weatherChanceConfiguration = new WeatherChanceConfiguration();
        if (!this.weatherChanceConfiguration.load(plugin)) {
            fileNameErrors.add(this.weatherChanceConfiguration.getFileName());
        }
        for (String fileName : fileNameErrors) {
            logger.severe("Failed to load settings for " + fileName);
        }
    }

    public void startup() {
        this.setPrefix();
        this.plugin.getLogger().info("Preparing to load...");
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.worldHandler = new SeasonsWorlds(this);
            new WorldTicker().runTaskTimer((Plugin)this.plugin, 0L, 20L);
            ChangeCommand changeCommand = new ChangeCommand();
            this.setCommandExecutor("season", new SeasonsCommand());
            this.setCommandExecutor("changeday", changeCommand);
            this.setCommandExecutor("changeweather", changeCommand);
            this.setCommandExecutor("changeseason", changeCommand);
            PluginManager pluginManager = Bukkit.getPluginManager();
            pluginManager.registerEvents((Listener)new SeasonalListener(), (Plugin)this.plugin);
            pluginManager.registerEvents((Listener)new TitleMessageHandler(), (Plugin)this.plugin);
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new SeasonsPlaceholderExpansion(this).register();
            }
            this.plugin.getLogger().info("Seasons has been loaded!");
        });
    }

    private void setCommandExecutor(String command, CommandExecutor executor) {
        PluginCommand pluginCommand = Bukkit.getPluginCommand((String)command);
        if (pluginCommand != null) {
            pluginCommand.setExecutor(executor);
        }
    }

    public void disable() {
        this.plugin.getLogger().info("Saving all seasons-enabled worlds...");
        if (this.worldHandler.saveAllWorlds()) {
            this.plugin.getLogger().info("Saved all worlds successfully");
        } else {
            this.plugin.getLogger().severe("Failed to save all worlds");
        }
        for (UUID uuid : SeasonsPotionEffect.PENDING.keySet()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) continue;
            player.removePotionEffect(SeasonsPotionEffect.PENDING.get(uuid));
        }
    }

    public void addEffects(Effect ... effects) {
        this.effects.addAll(Arrays.asList(effects));
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public SeasonsConfig getSeasonsConfig() {
        return this.config;
    }

    public SeasonsLanguageConfiguration getLanguageConfig() {
        return this.languageConfig;
    }

    public WeatherChanceConfiguration getWeatherChanceConfiguration() {
        return this.weatherChanceConfiguration;
    }

    public SeasonsWorlds getWorldHandler() {
        return this.worldHandler;
    }

    public List<Cycle> getCycles() {
        return this.worldHandler.getParsedCycles();
    }

    public Cycle getWorldCycle(World world) {
        for (Cycle cycle : this.worldHandler.getParsedCycles()) {
            if (!cycle.getWorld().equals(world)) continue;
            return cycle;
        }
        return null;
    }

    public void addCycle(Cycle cycle) {
        Validate.notNull((Object)cycle);
        this.worldHandler.getParsedCycles().add(cycle);
    }

    public void setPrefix() {
        PREFIX = this.languageConfig.getStringOrDefault("misc.prefix", ChatColor.GOLD + ChatColor.BOLD.toString() + "Seasons" + ChatColor.GRAY + "\u2219 " + ChatColor.RESET).orElse("");
    }

    public static Seasons getInstance() {
        return INSTANCE;
    }

    static {
        RANDOM = new Random();
    }
}

