/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_13_R1.good;

import java.util.Collections;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.TickableEffect;

public class WindInYourBoots
extends Effect
implements TickableEffect {
    private int secondsPast = 0;

    public WindInYourBoots() {
        super("Wind in Your Boots", "Random chance to gain Speed 1 for 20 seconds every 2 minutes", Collections.singletonList(Weather.BREEZY), true);
        this.setIgnoreRoof(false);
    }

    @Override
    public String getId() {
        return "wind-in-your-boots";
    }

    @Override
    public void onTrigger(World world) {
        this.secondsPast = 0;
    }

    @Override
    public void onTick(Cycle cycle) {
        if (this.secondsPast >= 120) {
            int random = Seasons.RANDOM.nextInt(10);
            if (random < 5) {
                World world = cycle.getWorld();
                for (Player player : world.getPlayers()) {
                    if (!this.isEnabled() || player.hasPotionEffect(PotionEffectType.SPEED)) continue;
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 400, 0));
                    this.sendGiveMessage(player, ChatColor.GREEN + "You feel a rush of Wind in your Boots and go hurtling forwards!");
                }
            }
            this.secondsPast = 0;
        } else {
            ++this.secondsPast;
        }
    }
}

