/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_13_R1.bad;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.LocalTime;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;

public class HoldOntoYourHat
extends Effect {
    private static final Cache<Player, LocalTime> buffer = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public HoldOntoYourHat() {
        super("Hold onto Your Hat", "A small chance that your hat will fall off when you put it on", Collections.singletonList(Weather.BREEZY), false);
        this.setIgnoreRoof(false);
    }

    @Override
    public String getId() {
        return "hold-onto-your-hat";
    }

    private void chanceHat(Player player) {
        if (this.isPlayerCycleApplicable(player)) {
            int random;
            PlayerInventory inventory = player.getInventory();
            ItemStack helmet = inventory.getHelmet();
            if (helmet == null) {
                return;
            }
            if (helmet.getType() == Material.LEATHER_HELMET && (random = Seasons.RANDOM.nextInt(100)) < 25) {
                player.getWorld().dropItem(player.getLocation(), helmet);
                inventory.setHelmet(null);
                this.sendGiveMessage(player, ChatColor.YELLOW + "Your hat just blew off, oh dear!");
            }
        }
    }

    @Override
    public void onTrigger(World world) {
        for (Player player : world.getPlayers()) {
            this.chanceHat(player);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (buffer.getIfPresent((Object)player) == null) {
            this.chanceHat(player);
            buffer.put((Object)player, (Object)LocalTime.now());
        }
    }
}

