/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_12_2_R1.good;

import java.util.Collections;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.SeasonsPotionEffect;

public class Legacy_PrimitiveHeating
extends SeasonsPotionEffect {
    private static final Material[] HOT_MATERIALS = new Material[]{Material.LAVA_BUCKET, Material.BLAZE_POWDER, Material.BLAZE_ROD, Material.DRAGONS_BREATH, Material.MAGMA_CREAM};

    public Legacy_PrimitiveHeating() {
        super("Primitive Heating", "Receive Resistance 1 when your inventory contains a very hot item", Collections.singletonList(Weather.COLD), true, new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, Integer.MAX_VALUE, 0));
    }

    @Override
    public String getId() {
        return "primitive-heating";
    }

    @Override
    public boolean shouldGive(Player player) {
        if (this.isPlayerCycleApplicable(player)) {
            PlayerInventory inventory = player.getInventory();
            for (Material material : HOT_MATERIALS) {
                if (!inventory.contains(material)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void sendGiveMessage(Player player) {
        this.sendGiveMessage(player, ChatColor.GREEN + "A hot item in your inventory warms your heart and makes you Resistant to the cold world");
    }

    @Override
    public void sendRemoveMessage(Player player) {
        this.sendRemoveMessage(player, ChatColor.YELLOW + "Your body is no longer warmed and it's Resistance wears away...");
    }

    @EventHandler
    public void onInventoryClick(final InventoryClickEvent event) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                if (event.getWhoClicked() instanceof Player) {
                    Player player = (Player)event.getWhoClicked();
                    if (Legacy_PrimitiveHeating.this.shouldGive(player)) {
                        Legacy_PrimitiveHeating.this.giveEffect(player, false);
                    } else {
                        Legacy_PrimitiveHeating.this.removeEffect(player, false);
                    }
                }
            }
        };
        runnable.runTaskLater((Plugin)Seasons.getInstance().getPlugin(), 10L);
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Player) {
            final Player player = (Player)event.getEntity();
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    Legacy_PrimitiveHeating.this.giveEffect(player, true);
                }
            };
            runnable.runTaskLater((Plugin)Seasons.getInstance().getPlugin(), 10L);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (!this.shouldGive(player) && this.isHotItem(event.getItemDrop().getItemStack())) {
            this.removeEffect(player, false, true);
        }
    }

    private boolean isHotItem(ItemStack item) {
        for (Material material : HOT_MATERIALS) {
            if (item.getType() != material) continue;
            return true;
        }
        return false;
    }
}

