/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_12_2_R1.bad;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.TickableEffect;

public class Legacy_TheShivers
extends Effect
implements TickableEffect {
    private Map<Player, Integer> secondsPast = new HashMap<Player, Integer>();

    public Legacy_TheShivers() {
        super("The Shivers", "Take damage when moving in water and be warned, this effect will last until death", Collections.singletonList(Weather.CHILLY), false);
    }

    @Override
    public String getId() {
        return "the-shivers";
    }

    private void damage(Player player) {
        if (this.isPlayerCycleApplicable(player) && !player.isInsideVehicle()) {
            Block block = player.getLocation().getBlock();
            if (block.getType() == Material.STATIONARY_WATER && !(player.getVehicle() instanceof Boat)) {
                player.damage(1.0);
                if (!this.secondsPast.containsKey(player)) {
                    this.secondsPast.put(player, 10);
                }
            } else {
                this.secondsPast.remove(player);
            }
        }
    }

    @Override
    public void onTrigger(World world) {
        this.secondsPast.clear();
        for (Player player : world.getPlayers()) {
            this.damage(player);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        this.damage(event.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        this.secondsPast.remove(event.getEntity());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.secondsPast.remove(event.getPlayer());
    }

    @Override
    public void onTick(Cycle cycle) {
        for (Player player : cycle.getWorld().getPlayers()) {
            if (!this.secondsPast.containsKey(player)) continue;
            int seconds = this.secondsPast.get(player);
            if (seconds >= 15) {
                this.sendGiveMessage(player, ChatColor.RED + "The freezing water is killing you, get out of it if you want to live!");
                this.secondsPast.replace(player, 0);
                continue;
            }
            this.secondsPast.replace(player, seconds + 1);
        }
    }
}

