/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.models.effect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import uk.co.harieo.seasons.plugin.events.DayEndEvent;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;

public abstract class SeasonsPotionEffect
extends Effect {
    public static final Map<UUID, PotionEffectType> PENDING = new HashMap<UUID, PotionEffectType>();
    private PotionEffect effect;

    public SeasonsPotionEffect(String name, String description, List<Weather> weathers, boolean good, PotionEffect effect) {
        super(name, description, weathers, good);
        this.effect = effect;
    }

    public abstract boolean shouldGive(Player var1);

    protected void giveEffect(Player player, boolean sendMessage) {
        if (this.shouldGive(player) && !player.hasPotionEffect(this.effect.getType())) {
            player.addPotionEffect(this.effect);
            PENDING.put(player.getUniqueId(), this.effect.getType());
            if (sendMessage) {
                this.sendGiveMessage(player);
            }
        }
    }

    protected void removeEffect(Player player, boolean sendMessage, boolean force) {
        if (this.isPlayerCycleApplicable(player) || force) {
            player.removePotionEffect(this.effect.getType());
            PENDING.remove(player.getUniqueId());
        }
        if (sendMessage) {
            this.sendRemoveMessage(player);
        }
    }

    protected void removeEffect(Player player, boolean sendMessage) {
        this.removeEffect(player, sendMessage, false);
    }

    public abstract void sendGiveMessage(Player var1);

    public abstract void sendRemoveMessage(Player var1);

    public PotionEffect getEffect() {
        return this.effect;
    }

    @Override
    public void onTrigger(World world) {
        for (Player player : world.getPlayers()) {
            this.giveEffect(player, true);
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            this.giveEffect(event.getPlayer(), false);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            this.giveEffect(player, true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            this.removeEffect(player, false, false);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player) && this.shouldGive(player)) {
            this.giveEffect(player, true);
            return;
        }
        this.removeEffect(player, false, true);
    }

    @EventHandler
    public void onDayEnd(DayEndEvent event) {
        if (this.isWeatherApplicable(event.getChangeFrom())) {
            World world = event.getCycle().getWorld();
            for (Player player : world.getPlayers()) {
                this.removeEffect(player, true, true);
            }
        }
    }
}

