/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.models.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.configuration.SeasonsConfig;
import uk.co.harieo.seasons.plugin.configuration.SeasonsLanguageConfiguration;
import uk.co.harieo.seasons.plugin.events.SeasonsWeatherChangeEvent;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Weather;

public abstract class Effect
implements Listener {
    private static final List<String> cache = new ArrayList<String>();
    private final String name;
    private final String description;
    private final List<Weather> weathers;
    private final boolean isGood;
    private boolean ignoreRoof = true;

    public Effect(String name, String description, List<Weather> weathers, boolean good) {
        this.name = name;
        this.description = description;
        this.weathers = weathers;
        this.isGood = good;
        Seasons seasons = Seasons.getInstance();
        if (!cache.contains(name) && seasons.getSeasonsConfig().hasEnabledEffects()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)seasons.getPlugin());
            cache.add(name);
        }
    }

    public abstract String getId();

    private void sendTriggerMessage(World world) {
        Optional<String> triggerMessage = this.getMessageOrDefault("on-trigger", "A language configuration error occurred here...");
        if (triggerMessage.isPresent() && this.isEnabled()) {
            for (Player player : world.getPlayers()) {
                player.sendMessage(Seasons.PREFIX + triggerMessage.get());
            }
        }
    }

    protected void sendGiveMessage(Player player, String orElse) {
        this.getMessageOrDefault("on-give", orElse).ifPresent(message -> player.sendMessage(Seasons.PREFIX + message));
    }

    protected void sendRemoveMessage(Player player, String orElse) {
        this.getMessageOrDefault("on-remove", orElse).ifPresent(message -> player.sendMessage(Seasons.PREFIX + message));
    }

    private Optional<String> getMessageOrDefault(String messageType, String orElse) {
        SeasonsLanguageConfiguration languageConfiguration = Seasons.getInstance().getLanguageConfig();
        return languageConfiguration.getStringOrDefault("effects." + messageType + "." + this.getId(), orElse);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Weather> getWeathers() {
        return this.weathers;
    }

    public boolean isGood() {
        return this.isGood;
    }

    public boolean isWeatherApplicable(Weather weather) {
        return this.getWeathers().contains((Object)weather);
    }

    public boolean isIgnoringRoof() {
        return this.ignoreRoof;
    }

    protected void setIgnoreRoof(boolean ignoreRoof) {
        this.ignoreRoof = ignoreRoof;
    }

    protected boolean isPlayerCycleApplicable(Player player) {
        Cycle cycle = Seasons.getInstance().getWorldCycle(player.getWorld());
        return cycle != null && this.isWeatherApplicable(cycle.getWeather()) && this.checkRoof(player) && this.isEnabled();
    }

    @EventHandler
    public void onWeatherChange(SeasonsWeatherChangeEvent event) {
        if (this.isWeatherApplicable(event.getChangedTo())) {
            World world = event.getCycle().getWorld();
            this.onTrigger(world);
            this.sendTriggerMessage(world);
        }
    }

    public abstract void onTrigger(World var1);

    public boolean isEnabled() {
        for (String disabledEffectName : Seasons.getInstance().getSeasonsConfig().getDisabledEffects()) {
            if (!disabledEffectName.equalsIgnoreCase(this.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkRoof(Player player) {
        return this.ignoreRoof || !Effect.isUnderRoof(player);
    }

    private static boolean isUnderRoof(Player player) {
        Location playerLocation = player.getLocation().clone();
        SeasonsConfig config = Seasons.getInstance().getSeasonsConfig();
        for (int i = 1; i < config.getRoofHeight(); ++i) {
            Block block = playerLocation.add(0.0, 1.0, 0.0).getBlock();
            if (block.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

