/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.configuration.StaticPlaceholders;

public enum Season {
    SPRING("Spring", "The sun rises, the flowers smell fresh and there is a Spring in your step... literally!", ChatColor.YELLOW),
    SUMMER("Summer", "Today feels warmer than the others, maybe even too warm... Summer has arrived!", ChatColor.GOLD),
    AUTUMN("Autumn", "A cool breeze whispers to the leaves that fall from the trees, \"it's Autumn!\"", ChatColor.DARK_GREEN),
    WINTER("Winter", "A few snowflakes fall and the world grows cold, time for Winter to make it's mark...", ChatColor.BLUE);

    private final String name;
    private final String message;
    private final ChatColor color;

    private Season(String name, String message, ChatColor seasonColor) {
        this.name = name;
        this.message = message;
        this.color = seasonColor;
    }

    public String getName() {
        return Seasons.getInstance().getLanguageConfig().getStringOrDefault("seasons.name." + this.name().toLowerCase(), this.name).orElse("");
    }

    public String getRawName() {
        return ChatColor.stripColor((String)this.getName());
    }

    public Optional<String> getMessage() {
        return Seasons.getInstance().getLanguageConfig().getStringOrDefault("seasons.on-trigger." + this.name().toLowerCase(), this.message).map(message -> message.replaceAll(StaticPlaceholders.SEASON.toString(), this.getName()));
    }

    public ChatColor getColor() {
        return this.color;
    }

    public String toString() {
        return this.color + this.name;
    }

    public static Season fromName(String name) {
        for (Season season : Season.values()) {
            if (!season.getRawName().equalsIgnoreCase(name.toLowerCase())) continue;
            return season;
        }
        return null;
    }

    public static Season next(Season currentSeason) {
        Validate.notNull((Object)((Object)currentSeason));
        List<Season> seasons = Arrays.asList(Season.values());
        int index = seasons.indexOf((Object)currentSeason);
        if (index + 1 >= seasons.size()) {
            return seasons.get(0);
        }
        return seasons.get(index + 1);
    }

    public static List<String> getSeasonsList() {
        ArrayList<String> list = new ArrayList<String>();
        for (Season season : Season.values()) {
            list.add(season.getName().toLowerCase());
        }
        return list;
    }
}

