/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.configuration;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.configuration.ConfigurationProvider;

public class SeasonsLanguageConfiguration
implements ConfigurationProvider {
    private static final String CANCEL_KEY = "none";
    private FileConfiguration config;
    private double currentVersion;

    @Override
    public String getFileName() {
        return "lang.yml";
    }

    @Override
    public boolean load(JavaPlugin plugin) {
        try {
            this.config = this.getConfiguration(plugin);
            this.currentVersion = this.config.getDouble("version");
            if (this.currentVersion != this.getLatestVersion() && !this.attemptVersionInjection(plugin, this.config)) {
                this.verifyVersion();
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public double getLatestVersion() {
        return 4.0;
    }

    @Override
    public double getCurrentVersion() {
        return this.currentVersion;
    }

    public boolean attemptVersionInjection(JavaPlugin plugin, FileConfiguration config) {
        if (this.getCurrentVersion() == 3.0) {
            double versionUpdatingTo = 4.0;
            config.set("misc.weather-change", (Object)"&7The weather has changed");
            config.set("misc.season-change", (Object)"&7The season has changed");
            config.set("version", (Object)versionUpdatingTo);
            try {
                config.save(this.getFile(plugin));
                plugin.getLogger().info("Your language file has been automatically updated to version " + versionUpdatingTo);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public Optional<String> getString(String key) {
        String value = this.config.getString(key);
        if (value == null || this.isCancelled(value)) {
            return Optional.empty();
        }
        return Optional.of(ChatColor.translateAlternateColorCodes((char)'&', (String)value));
    }

    public Optional<String> getStringOrDefault(String key, String orElse) {
        if (this.config.isSet(key)) {
            return this.getString(key);
        }
        return Optional.of(orElse);
    }

    public List<String> getStringList(String key) {
        return this.config.getStringList(key).stream().map(string -> ChatColor.translateAlternateColorCodes((char)'&', (String)string)).collect(Collectors.toList());
    }

    private boolean isCancelled(String value) {
        return value.equalsIgnoreCase(CANCEL_KEY);
    }
}

