/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.configuration;

import java.io.IOException;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.actionbar.SeasonsActionBar;
import uk.co.harieo.seasons.plugin.actionbar.TitleMessageHandler;
import uk.co.harieo.seasons.plugin.configuration.ConfigurationProvider;

public class SeasonsConfig
implements ConfigurationProvider {
    private double currentVersion;
    private int daysPerSeason;
    private int secondsPerDamage;
    private int roofHeight;
    private boolean enableEffects;
    private List<String> disabledWorlds;
    private List<String> disabledWeathers;
    private List<String> disabledEffects;

    @Override
    public boolean load(JavaPlugin plugin) {
        FileConfiguration config;
        try {
            config = this.getConfiguration(plugin);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.currentVersion = config.getDouble("version");
        if (this.currentVersion != this.getLatestVersion() && !this.attemptVersionInjection(plugin, config)) {
            this.verifyVersion();
        }
        this.daysPerSeason = config.getInt("DaysPerSeason");
        this.secondsPerDamage = config.getInt("SecondsOfDamage");
        this.roofHeight = config.getInt("RoofHeight");
        this.enableEffects = config.getBoolean("CustomWeathers");
        if (config.getBoolean("ActionBar")) {
            SeasonsActionBar.start();
        } else {
            SeasonsActionBar.stop();
        }
        TitleMessageHandler.setOnSeasonChange(config.getBoolean("TitleMessages.season"));
        TitleMessageHandler.setOnWeatherChange(config.getBoolean("TitleMessages.weather"));
        this.disabledWorlds = config.getStringList("disabled-worlds");
        this.disabledWeathers = config.getStringList("disabled-weathers");
        this.disabledEffects = config.getStringList("disabled-effects");
        plugin.getLogger().info(this.disabledWorlds.size() + " worlds have been disabled, " + this.disabledWeathers.size() + " weathers have been disabled and " + this.disabledEffects.size() + " have been disabled");
        return true;
    }

    @Override
    public String getFileName() {
        return "config.yml";
    }

    @Override
    public double getLatestVersion() {
        return 4.0;
    }

    @Override
    public double getCurrentVersion() {
        return this.currentVersion;
    }

    public boolean attemptVersionInjection(JavaPlugin plugin, FileConfiguration config) {
        if (this.getCurrentVersion() == 3.0) {
            double versionUpdatingTo = 4.0;
            config.set("TitleMessages.season", (Object)false);
            config.set("TitleMessages.weather", (Object)false);
            config.set("version", (Object)versionUpdatingTo);
            try {
                config.save(this.getFile(plugin));
                plugin.getLogger().info("Your configuration file has been automatically updated to version " + versionUpdatingTo);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public int getDaysPerSeason() {
        return this.daysPerSeason;
    }

    public int getSecondsPerDamage() {
        return this.secondsPerDamage;
    }

    public int getRoofHeight() {
        return this.roofHeight;
    }

    public boolean hasEnabledEffects() {
        return this.enableEffects;
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public List<String> getDisabledWeathers() {
        return this.disabledWeathers;
    }

    public List<String> getDisabledEffects() {
        return this.disabledEffects;
    }
}

