/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import uk.co.harieo.seasons.plugin.Seasons;

public interface ConfigurationProvider {
    public String getFileName();

    public boolean load(JavaPlugin var1);

    public double getLatestVersion();

    public double getCurrentVersion();

    default public File getFile(JavaPlugin plugin) {
        return new File(plugin.getDataFolder(), this.getFileName());
    }

    default public FileConfiguration getConfiguration(JavaPlugin plugin) throws IOException {
        YamlConfiguration configuration;
        File configFile;
        block16: {
            File dataFolder = plugin.getDataFolder();
            if (!dataFolder.exists() && !dataFolder.mkdir()) {
                throw new IOException("Failed to create plugin data folder");
            }
            String fileName = this.getFileName();
            configFile = this.getFile(plugin);
            if (!configFile.exists()) {
                try (InputStream stream = plugin.getResource(fileName);){
                    if (stream != null) {
                        Files.copy(stream, configFile.toPath(), new CopyOption[0]);
                        break block16;
                    }
                    throw new IOException("Failed to get resource stream for " + fileName);
                }
            }
        }
        if (!(configuration = YamlConfiguration.loadConfiguration((File)configFile)).isSet("version")) {
            configuration.set("version", (Object)this.getLatestVersion());
            configuration.save(configFile);
        }
        return configuration;
    }

    default public void verifyVersion() {
        if (this.getCurrentVersion() < this.getLatestVersion()) {
            Seasons.getInstance().getPlugin().getLogger().warning("WARNING: Your " + this.getFileName() + " file is out of date, please backup and delete it to receive this update!");
        }
    }
}

