/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.commands;

import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.configuration.SeasonsConfig;

class SeasonsInfoSubcommand {
    SeasonsInfoSubcommand() {
    }

    static void requestConfigurationDetails(CommandSender sender) {
        if (!sender.hasPermission("seasons.config")) {
            sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "You do not have permission to do that!");
            return;
        }
        SeasonsConfig config = Seasons.getInstance().getSeasonsConfig();
        sender.sendMessage(Seasons.PREFIX + ChatColor.GRAY + "Your Configuration Settings (from config.yml):");
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Days per Season", String.valueOf(config.getDaysPerSeason())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Seconds per Damage", String.valueOf(config.getSecondsPerDamage())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Roof Height", String.valueOf(config.getRoofHeight())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Effects are Enabled", String.valueOf(config.hasEnabledEffects())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Disabled Worlds", SeasonsInfoSubcommand.listContentsToString(config.getDisabledWorlds())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Disabled Weathers", SeasonsInfoSubcommand.listContentsToString(config.getDisabledWeathers())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Disabled Effects", SeasonsInfoSubcommand.listContentsToString(config.getDisabledEffects())));
        sender.sendMessage(SeasonsInfoSubcommand.createOptionMessage("Config Version", String.valueOf(config.getCurrentVersion())));
    }

    private static String createOptionMessage(String key, String value) {
        return ChatColor.YELLOW + key + ": " + ChatColor.LIGHT_PURPLE + value;
    }

    private static String listContentsToString(List<String> list) {
        if (list.isEmpty()) {
            return "None";
        }
        StringBuilder builder = new StringBuilder();
        for (String s : list) {
            builder.append(s);
            if (list.indexOf(s) >= list.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

