/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.commands;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.commands.SeasonsCommand;
import uk.co.harieo.seasons.plugin.configuration.SeasonsLanguageConfiguration;
import uk.co.harieo.seasons.plugin.configuration.StaticPlaceholders;
import uk.co.harieo.seasons.plugin.events.DayEndEvent;
import uk.co.harieo.seasons.plugin.events.SeasonChangeEvent;
import uk.co.harieo.seasons.plugin.events.SeasonsWeatherChangeEvent;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;

public class ChangeCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        Seasons seasons = Seasons.getInstance();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args.length == 1) {
                Cycle cycle = seasons.getWorldCycle(player.getWorld());
                if (cycle == null) {
                    player.sendMessage(Seasons.PREFIX + ChatColor.RED + "You are not in a world that can have it's day changed!");
                    return false;
                }
                this.change(sender, command, args[0], cycle);
                return false;
            }
        }
        if (args.length < 2) {
            sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "Insufficient arguments: Expected /" + s + " <new value> <world>");
            return false;
        }
        World world = Bukkit.getWorld((String)args[1]);
        if (world == null) {
            sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "We couldn't find the world called " + args[1]);
            return false;
        }
        Cycle cycle = seasons.getWorldCycle(world);
        if (cycle == null) {
            SeasonsCommand.sendBarrenWorldError(sender);
            return false;
        }
        this.change(sender, command, args[0], cycle);
        return false;
    }

    private void change(CommandSender sender, Command command, String name, Cycle cycle) {
        World world = cycle.getWorld();
        PluginManager manager = Bukkit.getPluginManager();
        String commandLabel = command.getLabel();
        SeasonsLanguageConfiguration languageConfiguration = Seasons.getInstance().getLanguageConfig();
        if (commandLabel.equalsIgnoreCase("changeday")) {
            int newDay;
            if (this.hasInsufficientPermissions(sender, "seasons.change.day")) {
                SeasonsCommand.sendPermissionDenied(sender);
                return;
            }
            try {
                newDay = Integer.parseInt(name);
            }
            catch (NumberFormatException ignored) {
                sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "Invalid argument: Expected number value /changeday <value>");
                return;
            }
            cycle.setDay(newDay);
            languageConfiguration.getStringOrDefault("command.force-day", ChatColor.GRAY + "Time shatters before you, days fly by and it is now Day " + ChatColor.LIGHT_PURPLE + newDay).ifPresent(message -> this.broadcast(world, Seasons.PREFIX + message.replaceAll(StaticPlaceholders.DAY.toString(), String.valueOf(newDay))));
            sender.sendMessage(Seasons.PREFIX + ChatColor.GREEN + "Successfully " + ChatColor.GRAY + "changed the day to " + ChatColor.YELLOW + newDay + ChatColor.GRAY + " in " + ChatColor.LIGHT_PURPLE + world.getName());
        } else if (commandLabel.equalsIgnoreCase("changeweather")) {
            if (this.hasInsufficientPermissions(sender, "seasons.change.weather")) {
                SeasonsCommand.sendPermissionDenied(sender);
                return;
            }
            Weather weather = Weather.fromName(name);
            if (weather == null) {
                sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "We couldn't find a weather called " + name);
                return;
            }
            if (Weather.isManuallyDisabled(weather)) {
                sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "That weather has been disabled by a server administrator via the config!");
                return;
            }
            Weather oldWeather = cycle.getWeather();
            cycle.setWeather(weather);
            String weatherName = weather.getName();
            languageConfiguration.getStringOrDefault("command.force-weather", "The skies grow silent and with a great rumble the weather turns to " + ChatColor.GREEN + weatherName).ifPresent(message -> this.broadcast(world, Seasons.PREFIX + message.replaceAll(StaticPlaceholders.WEATHER.toString(), ChatColor.GREEN + weatherName)));
            sender.sendMessage(Seasons.PREFIX + ChatColor.GREEN + "Successfully " + ChatColor.GRAY + "changed the weather to " + ChatColor.YELLOW + weatherName + ChatColor.GRAY + " in " + ChatColor.LIGHT_PURPLE + world.getName());
            manager.callEvent((Event)new DayEndEvent(cycle, oldWeather, false));
            manager.callEvent((Event)new SeasonsWeatherChangeEvent(cycle, oldWeather, weather, false));
        } else if (commandLabel.equalsIgnoreCase("changeseason")) {
            if (this.hasInsufficientPermissions(sender, "seasons.change.season")) {
                SeasonsCommand.sendPermissionDenied(sender);
                return;
            }
            Season season = Season.fromName(name);
            if (season == null) {
                sender.sendMessage(Seasons.PREFIX + ChatColor.RED + "We couldn't find a season called " + name);
                return;
            }
            String seasonName = season.getName();
            manager.callEvent((Event)new SeasonChangeEvent(cycle, season, cycle.getSeason(), false));
            cycle.setSeason(season);
            languageConfiguration.getStringOrDefault("command.force-season", ChatColor.GRAY + "The air around you changes mystically and becomes " + ChatColor.GOLD + seasonName).ifPresent(message -> this.broadcast(world, Seasons.PREFIX + message.replaceAll(StaticPlaceholders.SEASON.toString(), ChatColor.YELLOW + seasonName)));
            sender.sendMessage(Seasons.PREFIX + ChatColor.GREEN + "Successfully " + ChatColor.GRAY + "changed the season to " + ChatColor.YELLOW + season.getName() + ChatColor.GRAY + " in " + ChatColor.LIGHT_PURPLE + world.getName());
        } else {
            throw new IllegalArgumentException("A command was sent called " + command + " but couldn't be processed");
        }
    }

    private void broadcast(World world, String message) {
        for (Player player : world.getPlayers()) {
            player.sendMessage(message);
        }
    }

    private boolean hasInsufficientPermissions(CommandSender sender, String permission) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return !player.isOp() && !player.hasPermission(permission);
        }
        return false;
    }
}

