/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.actionbar;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.events.SeasonChangeEvent;
import uk.co.harieo.seasons.plugin.events.SeasonsWeatherChangeEvent;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;

public class TitleMessageHandler
implements Listener {
    private static boolean SEASON_CHANGE = false;
    private static boolean WEATHER_CHANGE = false;
    private final Set<UUID> buffer = new HashSet<UUID>();

    @EventHandler
    public void onWeatherChange(SeasonsWeatherChangeEvent event) {
        if (WEATHER_CHANGE) {
            Weather weather = event.getChangedTo();
            this.consumeCyclePlayers(player -> {
                UUID uuid = player.getUniqueId();
                if (this.buffer.contains(uuid)) {
                    this.buffer.remove(uuid);
                    return;
                }
                player.sendTitle(weather.getName(), Seasons.getInstance().getLanguageConfig().getString("misc.weather-change").orElse(ChatColor.GRAY + "The weather has changed"), 10, 70, 20);
            }, event.getCycle());
        }
    }

    @EventHandler
    public void onSeasonChange(SeasonChangeEvent event) {
        if (SEASON_CHANGE) {
            Season season = event.getChangedTo();
            this.consumeCyclePlayers(player -> {
                player.sendTitle(season.getName(), Seasons.getInstance().getLanguageConfig().getString("misc.season-change").orElse(ChatColor.GRAY + "The season has changed"), 10, 70, 20);
                this.buffer.add(player.getUniqueId());
            }, event.getCycle());
        }
    }

    private void consumeCyclePlayers(Consumer<Player> playerConsumer, Cycle cycle) {
        cycle.getWorld().getPlayers().forEach(playerConsumer);
    }

    public static void setOnSeasonChange(boolean enabled) {
        SEASON_CHANGE = enabled;
    }

    public static void setOnWeatherChange(boolean enabled) {
        WEATHER_CHANGE = enabled;
    }
}

