/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin.actionbar;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;

public class SeasonsActionBar
implements Runnable {
    private static final SeasonsActionBar instance = new SeasonsActionBar();
    private BukkitTask task;

    @Override
    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            World world = player.getWorld();
            Cycle cycle = Seasons.getInstance().getWorldCycle(world);
            if (cycle == null) continue;
            Season season = cycle.getSeason();
            Weather weather = cycle.getWeather();
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, new ComponentBuilder(season.getName()).color(season.getColor().asBungee()).append("\u2219 ").color(ChatColor.GRAY).append(weather.getName()).create());
        }
    }

    public static void start() {
        if (SeasonsActionBar.instance.task == null) {
            SeasonsActionBar.instance.task = Bukkit.getScheduler().runTaskTimer((Plugin)Seasons.getInstance().getPlugin(), (Runnable)instance, 0L, 40L);
        }
    }

    public static void stop() {
        if (SeasonsActionBar.instance.task != null) {
            SeasonsActionBar.instance.task.cancel();
            SeasonsActionBar.instance.task = null;
        }
    }
}

