/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.plugin;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.events.DayEndEvent;
import uk.co.harieo.seasons.plugin.events.SeasonChangeEvent;
import uk.co.harieo.seasons.plugin.events.SeasonsWeatherChangeEvent;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Season;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.TickableEffect;

public class WorldTicker
extends BukkitRunnable {
    public void run() {
        Seasons seasons = Seasons.getInstance();
        for (Cycle cycle : seasons.getCycles()) {
            boolean isUnregisteredNight;
            World world = cycle.getWorld();
            boolean isNight = cycle.getWeather() == Weather.NIGHT;
            boolean shouldProgressDay = world.getTime() >= 23850L && world.getTime() > 0L && isNight;
            boolean shouldProgressNight = !isNight && world.getTime() >= 12300L && world.getTime() < 12400L;
            boolean isUnregisteredDay = !isNight && world.getTime() > 12300L && world.getTime() < 23850L;
            boolean bl = isUnregisteredNight = isNight && world.getTime() > 0L && world.getTime() < 12300L;
            if (shouldProgressNight || isUnregisteredDay) {
                this.newNight(cycle);
                continue;
            }
            if (isUnregisteredNight || shouldProgressDay) {
                this.newDay(cycle);
                continue;
            }
            for (Effect effect : seasons.getEffects()) {
                if (!effect.isWeatherApplicable(cycle.getWeather()) || !(effect instanceof TickableEffect)) continue;
                TickableEffect tickableEffect = (TickableEffect)((Object)effect);
                tickableEffect.onTick(cycle);
            }
        }
    }

    private void newDay(Cycle cycle) {
        Season season;
        int day = cycle.getDay();
        if (day + 1 > Seasons.getInstance().getSeasonsConfig().getDaysPerSeason()) {
            cycle.setDay(1);
            season = Season.next(cycle.getSeason());
            Bukkit.getPluginManager().callEvent((Event)new SeasonChangeEvent(cycle, season, cycle.getSeason(), true));
            cycle.setSeason(season);
        } else {
            cycle.setDay(day + 1);
            season = cycle.getSeason();
        }
        Weather oldWeather = cycle.getWeather();
        Weather newWeather = Weather.randomWeather(season);
        cycle.setWeather(newWeather);
        Bukkit.getPluginManager().callEvent((Event)new SeasonsWeatherChangeEvent(cycle, oldWeather, newWeather, true));
    }

    private void newNight(Cycle cycle) {
        Weather oldWeather = cycle.getWeather();
        cycle.setWeather(Weather.NIGHT);
        PluginManager manager = Bukkit.getPluginManager();
        manager.callEvent((Event)new DayEndEvent(cycle, oldWeather, true));
    }
}

