/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_13_R1.bad;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.TickableEffect;

public class SolderingIron
extends Effect
implements TickableEffect {
    private static final Material[] SOLDERING_ITEMS = new Material[]{Material.BUCKET, Material.IRON_INGOT, Material.IRON_BLOCK, Material.IRON_DOOR, Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS, Material.ANVIL, Material.IRON_NUGGET, Material.IRON_BARS, Material.IRON_TRAPDOOR, Material.CHAINMAIL_HELMET, Material.CHAINMAIL_CHESTPLATE, Material.CHAINMAIL_LEGGINGS, Material.CHAINMAIL_BOOTS, Material.WATER_BUCKET, Material.LAVA_BUCKET};
    private Map<Player, Integer> secondsPast = new HashMap<Player, Integer>();

    public SolderingIron() {
        super("Soldering Iron", "Take damage if you hold a primarily iron item", Collections.singletonList(Weather.SCORCHING), false);
    }

    @Override
    public String getId() {
        return "soldering-iron";
    }

    private void checkHotbar(Player player) {
        PlayerInventory inventory = player.getInventory();
        boolean containsKey = this.secondsPast.containsKey(player);
        for (Material material : SOLDERING_ITEMS) {
            boolean containsMaterial;
            boolean bl = containsMaterial = inventory.getItemInMainHand().getType() == material || inventory.getItemInOffHand().getType() == material;
            if (!containsMaterial || containsKey) continue;
            this.secondsPast.put(player, 0);
            this.sendGiveMessage(player, ChatColor.RED + "The iron is soldering hot, don't hold it for too long!");
        }
        if (containsKey) {
            this.secondsPast.remove(player);
        }
    }

    private void delayedCheckHotbar(final Player player) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                SolderingIron.this.checkHotbar(player);
            }
        };
        runnable.runTaskLater((Plugin)Seasons.getInstance().getPlugin(), 10L);
    }

    @Override
    public void onTrigger(World world) {
        this.secondsPast.clear();
        for (Player player : world.getPlayers()) {
            this.checkHotbar(player);
        }
    }

    @Override
    public void onTick(Cycle cycle) {
        for (Player player : this.secondsPast.keySet()) {
            int seconds = this.secondsPast.get(player);
            if (seconds >= 5) {
                player.damage(1.0);
                continue;
            }
            this.secondsPast.replace(player, seconds + 1);
        }
    }

    @EventHandler
    public void onHotbarSwitch(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            this.delayedCheckHotbar(player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        if (event.getWhoClicked() instanceof Player && this.isPlayerCycleApplicable(player = (Player)event.getWhoClicked())) {
            this.delayedCheckHotbar(player);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            this.delayedCheckHotbar(player);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && this.isPlayerCycleApplicable(player = (Player)event.getEntity())) {
            this.delayedCheckHotbar(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.secondsPast.remove(event.getPlayer());
    }
}

