/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_13_R1.bad;

import java.util.Arrays;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Cycle;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;
import uk.co.harieo.seasons.plugin.models.effect.TickableEffect;

public class Frostbite
extends Effect
implements TickableEffect {
    private int secondsPast = 0;
    private boolean active = false;

    public Frostbite() {
        super("Frostbite", "Harms you if you do not have full armour on after 10 seconds down to half a heart", Arrays.asList(Weather.FREEZING, Weather.SNOWY), false);
        this.setIgnoreRoof(false);
    }

    @Override
    public String getId() {
        return "frostbite";
    }

    @Override
    public void onTrigger(World world) {
        this.secondsPast = 0;
    }

    private void damage(World world) {
        for (Player player : world.getPlayers()) {
            List<ItemStack> armour;
            if (!this.isPlayerCycleApplicable(player) || !(player.getHealth() > 1.0) || !(armour = Arrays.asList(player.getInventory().getArmorContents())).contains(null)) continue;
            player.damage(1.0);
        }
    }

    @Override
    public void onTick(Cycle cycle) {
        if (this.active) {
            if (this.secondsPast >= Seasons.getInstance().getSeasonsConfig().getSecondsPerDamage()) {
                this.damage(cycle.getWorld());
                this.secondsPast = 0;
            } else {
                ++this.secondsPast;
            }
        } else if (this.secondsPast >= 10) {
            this.active = true;
            this.secondsPast = 0;
        } else {
            ++this.secondsPast;
        }
    }
}

