/*
 * Decompiled with CFR 0.152.
 */
package uk.co.harieo.seasons.core.v1_12_2_R1.bad;

import java.util.Collections;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import uk.co.harieo.seasons.plugin.Seasons;
import uk.co.harieo.seasons.plugin.models.Weather;
import uk.co.harieo.seasons.plugin.models.effect.Effect;

public class Legacy_Icy
extends Effect {
    public Legacy_Icy() {
        super("Icy", "Any water you place down will turn to ice", Collections.singletonList(Weather.FREEZING), false);
    }

    @Override
    public String getId() {
        return "icy";
    }

    @Override
    public void onTrigger(World world) {
    }

    @EventHandler
    public void onWaterPlace(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player)) {
            final Block block = event.getBlockClicked().getRelative(event.getBlockFace());
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (block.getType() == Material.STATIONARY_WATER) {
                        block.setType(Material.ICE);
                    }
                }
            };
            runnable.runTaskLater((Plugin)Seasons.getInstance().getPlugin(), 10L);
        }
    }

    @EventHandler
    public void onWaterPickup(PlayerBucketFillEvent event) {
        Block block;
        Player player = event.getPlayer();
        if (this.isPlayerCycleApplicable(player) && (block = event.getBlockClicked().getRelative(event.getBlockFace())).getType() == Material.STATIONARY_WATER) {
            event.setItemStack(new ItemStack(Material.BUCKET));
            this.sendGiveMessage(player, ChatColor.RED + "The water freezes in the bucket so you decide to throw it away...");
        }
    }
}

