/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.modifiers;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class TraderModifier
extends Modifier
implements VolatileDataModifierHook {
    public TraderModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onExperienceDrop);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::beforeBlockBreak);
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.VOLATILE_DATA);
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = TraderModifier.getHeldTool((LivingEntity)event.getPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel((Modifier)this);
        }
        if (level > 0) {
            event.setExpToDrop(0);
        }
    }

    private void onExperienceDrop(LivingExperienceDropEvent event) {
        int level = 0;
        ToolStack tool = TraderModifier.getHeldTool((LivingEntity)event.getAttackingPlayer(), (InteractionHand)InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel((Modifier)this);
        }
        if (level > 0) {
            event.setDroppedExperience(0);
        }
    }

    @NotNull
    public List<ItemStack> processLoot(@NotNull IToolStackView tool, int level, List<ItemStack> generatedLoot, @NotNull LootContext context) {
        if ((double)RANDOM.nextFloat() < 0.1 * (double)level) {
            generatedLoot.addAll(generatedLoot);
        }
        return generatedLoot;
    }

    public void addVolatileData(@NotNull ToolRebuildContext context, @NotNull ModifierEntry modifier, @NotNull ModDataNBT volatileData) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        overslime.setFriend(volatileData);
    }
}

