/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationMaterials;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.data.material.MaterialIds;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OmnipotentModifier
extends Modifier
implements VolatileDataModifierHook,
MeleeDamageModifierHook,
ToolStatsModifierHook,
MeleeHitModifierHook,
ProjectileHitModifierHook {
    private static final String[] list = new String[]{TinkersInnovationMaterials.polychrome_alloy.toString(), MaterialIds.manyullyn.toString(), MaterialIds.queensSlime.toString(), MaterialIds.hepatizon.toString(), "tinkerscalibration:mangobberslime", "tinkerscalibration:mandite", "tinkerscalibration:darkmatter", "tinkerscalibration:redmatter", "tinkerscalibration:emperorslime"};

    public int getPriority() {
        return 1;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModifierHook[]{TinkerHooks.MELEE_DAMAGE, TinkerHooks.MELEE_HIT, TinkerHooks.PROJECTILE_HIT, TinkerHooks.TOOL_STATS, TinkerHooks.VOLATILE_DATA});
    }

    public void afterMeleeHit(@NotNull IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && OmnipotentModifier.comp(tool, "tinkerscalibration:redmatter") > 0) {
            target.m_21153_(target.m_21223_() * 0.8f);
        } else if (target != null && OmnipotentModifier.comp(tool, "tinkerscalibration:darkmatter") > 0) {
            target.m_21153_(target.m_21223_() * 0.9f);
        }
        if (target != null && OmnipotentModifier.comp(tool, "tinkerscalibration:mandite") > 0) {
            target.f_19802_ = 0;
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, @NotNull ModifierEntry modifier, @NotNull Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        boolean result = false;
        for (ModifierEntry entry : modifiers.getModifiers()) {
            if (!entry.getId().toString().equals("tinkerscalibration:bloodthirsty")) continue;
            result = true;
        }
        if (target != null && result && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            target.f_19802_ = 0;
        }
        return false;
    }

    public void addToolStats(@NotNull ToolRebuildContext context, @NotNull ModifierEntry modifier, @NotNull ModifierStatsBuilder builder) {
        int partnum = OmnipotentModifier.comp(context, MaterialIds.hepatizon.toString());
        if (partnum > 0) {
            if (context.getBaseStats().hasStat((IToolStat)ToolStats.VELOCITY)) {
                ToolStats.VELOCITY.add(builder, (double)(((Float)context.getBaseStats().get((IToolStat)ToolStats.VELOCITY)).floatValue() * (float)modifier.getLevel() * (float)partnum * 0.07f));
            }
            if (context.getBaseStats().hasStat((IToolStat)ToolStats.MINING_SPEED)) {
                ToolStats.MINING_SPEED.add(builder, (double)(((Float)context.getBaseStats().get((IToolStat)ToolStats.VELOCITY)).floatValue() * (float)modifier.getLevel() * (float)partnum * 0.07f));
            }
        }
        if ((partnum = OmnipotentModifier.comp(context)) > 0) {
            if (context.getBaseStats().hasStat((IToolStat)ToolStats.DURABILITY)) {
                ToolStats.DURABILITY.add(builder, (double)(modifier.getLevel() * partnum * 50));
            }
            if (context.getBaseStats().hasStat((IToolStat)ToolStats.ATTACK_DAMAGE)) {
                ToolStats.ATTACK_DAMAGE.add(builder, (double)(modifier.getLevel() * partnum * 2));
            }
        }
    }

    public float getMeleeDamage(@NotNull IToolStackView tool, @NotNull ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity target = context.getLivingTarget();
        int partnum = OmnipotentModifier.comp(tool, MaterialIds.manyullyn.toString());
        if (partnum > 0 && target != null) {
            damage += (target.m_21233_() - target.m_21223_()) * (0.05f + 0.05f * (float)modifier.getLevel() * (float)partnum);
        }
        return damage;
    }

    public void addVolatileData(@NotNull ToolRebuildContext context, @NotNull ModifierEntry modifier, @NotNull ModDataNBT volatileData) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        overslime.setFriend(volatileData);
        int partnum = OmnipotentModifier.comp(context, "tinkerscalibration:mangobberslime");
        if (partnum > 0) {
            volatileData.addSlots(SlotType.ABILITY, partnum);
            volatileData.addSlots(SlotType.UPGRADE, partnum);
        }
        if ((partnum = OmnipotentModifier.comp(context, MaterialIds.queensSlime.toString())) > 0) {
            overslime.addCapacity(volatileData, 200 * partnum * modifier.getLevel());
        }
        if ((partnum = OmnipotentModifier.comp(context, "tinkerscalibration:emperorslime")) > 0) {
            overslime.addCapacity(volatileData, (int)((double)overslime.getCapacity((IModDataView)volatileData) * 0.2 * (double)modifier.getLevel() * (double)partnum + 0.5));
        }
    }

    private static int comp(IToolStackView tool, String id) {
        int level = 0;
        for (int i = 1; i <= tool.getMaterials().size(); ++i) {
            if (!tool.getMaterial(i).getId().toString().equals(id)) continue;
            ++level;
        }
        return level;
    }

    private static int comp(ToolRebuildContext tool, String id) {
        int level = 0;
        for (int i = 1; i <= tool.getMaterials().size(); ++i) {
            if (!tool.getMaterial(i).getId().toString().equals(id)) continue;
            ++level;
        }
        return level;
    }

    private static int comp(IToolStackView tool) {
        int level = 0;
        for (int i = 1; i <= tool.getMaterials().size(); ++i) {
            if (tool.getMaterial(i).get().getTier() < 4 || !OmnipotentModifier.notfind(tool.getMaterial(i).getId().toString())) continue;
            ++level;
        }
        return level;
    }

    private static int comp(ToolRebuildContext tool) {
        int level = 0;
        for (int i = 1; i <= tool.getMaterials().size(); ++i) {
            if (tool.getMaterial(i).get().getTier() < 4 || !OmnipotentModifier.notfind(tool.getMaterial(i).getId().toString())) continue;
            ++level;
        }
        return level;
    }

    private static boolean notfind(String name) {
        for (String s : list) {
            if (!name.equals(s)) continue;
            return false;
        }
        return true;
    }
}

