/*
 * Decompiled with CFR 0.152.
 */
package kirito.Power;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class FlashPower
extends AbstractPower {
    public static final String POWER_ID = "FlashPower";
    public static final String NAME = "\u95ea\u5149";
    public static final String[] DESCRIPTIONS = new String[]{"\u6bcf\u53d7\u5230\u653b\u51fb\u65f6,\u653b\u51fb\u8005\u5931\u53bb", "\u70b9 \u529b\u91cf .\u56de\u5408\u5f00\u59cb\u65f6\u8be5buff\u6d88\u5931."};

    public FlashPower(AbstractCreature owner, int amount) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.img = ImageMaster.loadImage((String)"img/powers/Flash.png");
    }

    public void updateDescription() {
        this.description = String.valueOf(DESCRIPTIONS[0]) + this.amount + DESCRIPTIONS[1];
    }

    public int onAttacked(DamageInfo info, int damageAmt) {
        if (info.type != DamageInfo.DamageType.THORNS && info.type != DamageInfo.DamageType.HP_LOSS && info.owner != null && info.owner != this.owner) {
            this.flash();
            AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new ApplyPowerAction(info.owner, this.owner, (AbstractPower)new StrengthPower(info.owner, -this.amount), -this.amount));
        }
        this.updateDescription();
        return damageAmt;
    }

    public void atStartOfTurn() {
        this.flash();
        AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        this.updateDescription();
    }
}

