/*
 * Decompiled with CFR 0.152.
 */
package kirito.Power;

import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.ReducePowerAction;
import com.megacrit.cardcrawl.actions.common.RemoveSpecificPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.powers.StrengthPower;

public class BrokenRibsPower
extends AbstractPower {
    public static final String POWER_ID = "BrokenRibsPower";
    public static final String NAME = "\u65ad\u81c2";
    public static final String[] DESCRIPTIONS = new String[]{"\u56de\u5408\u5185,\u6bcf\u56de\u5408\u56de\u590d2\u70b9 \u529b\u91cf ."};
    private boolean justApplied = false;

    public BrokenRibsPower(AbstractCreature owner, int amount, boolean isSourceMonster) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = amount;
        this.updateDescription();
        this.img = ImageMaster.loadImage((String)"img/powers/BrokenRibs.png");
        if (AbstractDungeon.actionManager.turnHasEnded && isSourceMonster) {
            this.justApplied = true;
            this.type = AbstractPower.PowerType.DEBUFF;
            this.isTurnBased = true;
        }
    }

    public void updateDescription() {
        this.description = String.valueOf(this.amount) + DESCRIPTIONS[0];
    }

    public void atEndOfRound() {
        this.flash();
        if (this.justApplied) {
            this.justApplied = false;
            return;
        }
        if (this.amount == 0) {
            AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new RemoveSpecificPowerAction(this.owner, this.owner, POWER_ID));
        } else {
            AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new ReducePowerAction(this.owner, this.owner, POWER_ID, 1));
        }
        AbstractDungeon.actionManager.addToBottom((AbstractGameAction)new ApplyPowerAction(this.owner, this.owner, (AbstractPower)new StrengthPower(this.owner, 2), 2));
    }
}

