/*======================================================================================
                             "USER" ADJUSTABLE SETTINGS
======================================================================================*/

// TODO: Normalize values to be on a human range scale, whole numbers prefered, decimals usable for micro adjustments
// These values should have min/max limit checks included in their functions, so that the end user doesn't get crazy results

/*------------------------------------------------------------------------------
						SHADER SELECTION
------------------------------------------------------------------------------*/
// To disable / enable effects
// 0 = Disable  | 1 = Enable
#define USE_ANTI_ALIASING 1
#define USE_PRE_SHARPEN 1
// HDR NOT COMPLETED!!!
#define USE_HDR 0
#define USE_BLOOM 1
#define USE_TECHNICOLOR 1
#define USE_TONEMAP 1
#define USE_SEPIA 1
#define USE_VIGNETTE 0
// For use with Anaglyphic 3D glasses!!!
#define USE_ANAGLYPH 0
#define USE_POST_SHARPEN 1
#define USE_FINAL_LIMITER 0

/*------------------------------------------------------------------------------
						FXAA QUALITY SELECTION
------------------------------------------------------------------------------*/
// Set from 1 to 9 to balance between performance and quality
// Performance [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Quality
#define FXAA_QUALITY__PRESET 8

/*------------------------------------------------------------------------------
						FXAA SHADER
------------------------------------------------------------------------------*/
// Set from 1 to 9 to balance between minimum and maximum amount of anti aliasing blur
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
float fxaaQualitySubpix = 8;

// Set from 1 to 9 to balance between performance and strenght, affects AA processing based on contrast
// Performance [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Strenght
float fxaaQualityEdgeThreshold = 8;

// Set from 1 to 9 to balance between performance and strenght, affects AA processing on dark edges
// Performance [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Strenght
float fxaaQualityEdgeThresholdMin = 8;

/*------------------------------------------------------------------------------
						PRE_SHARPEN
------------------------------------------------------------------------------*/
//For higher precision in the calculation of the edge contours, requires a tiny bit more processing power
// 0 = Disable  | 1 = Enable
bool highQualitySharpen = 0;

// Set values to calculate the amount of  bluer produced by AA to consider for the sharpening pass
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define AverageBlur 0
#define CoefficientsBlur 0

// Set values of the sharpening amounts
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define SharpenEdge 0
#define SharpenContour 0

/*------------------------------------------------------------------------------
						BLOOM
------------------------------------------------------------------------------*/
 // Set from 1 to 9 to select a bloom preset
// NOTE: Preset value 1 to 9 takes control over the next 3 settings!
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
float BloomPreset = 5;

// Set from 1 to 9 to set the min. level at which the effect starts
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
float BloomThreshold = 5;
// Set from 1 to 9 to set the width of the effect
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
float BloomWidth = 5;
// Set from 1 to 9 to set the power of the effect
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
float BloomPower = 5;

/*------------------------------------------------------------------------------
						TECHNICOLOR
------------------------------------------------------------------------------*/
#define TechniAmount 0.08 // 1.00 = Max
#define TechniPower 4.2 // lower values = whitening

// lower values = stronger channel
#define redNegativeAmount 1.0 // 1.00 = Max
#define greenNegativeAmount 1.0 // 1.00 = Max
#define blueNegativeAmount 1.0 // 1.00 = Max

/*------------------------------------------------------------------------------
						TONEMAP
------------------------------------------------------------------------------*/
#define Gamma 1.05
#define Exposure 0.05
#define Saturation 0.6 // use negative values for less saturation. 
#define BlueShift 0.00 // Higher = more blue in image.
#define Bleach 0.00 // Bleach bypass, higher = stronger effect
#define Defog 0.000 // Strength of Lens Colors.
#define FogColor float4(0.00, 0.00, 0.00, 0.0) //Lens-style color filters for Blue, Red, Yellow, White.

/*------------------------------------------------------------------------------
						SEPIA
------------------------------------------------------------------------------*/
#define Desertsand // Color Tone, available tones can be seen in ColorTones.PNG (Do not use spaces in the name!)
// Set from 1 to 9 to balance between minimum and maximum amount of above chosen color tone to blend in
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define SepiaPower 1
// Set from 1 to 9 to balance between minimum and maximum amount of grey color to blend in
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define GreyPower 1

/*------------------------------------------------------------------------------
						VIGNETTE
------------------------------------------------------------------------------*/
// Vignette effect, process by which there is loss in clarity towards the corners and sides of the image, like a picture frame
#define VignetteCenter float2(0.500, 0.500) // Center of screen for effect.
#define VignetteRadius 1.00 // lower values = stronger radial effect from center
#define VignetteAmount -0.70 // Strength of black. -2.00 = Max Black, 1.00 = Max White.

/*------------------------------------------------------------------------------
						ANAGLYPH
------------------------------------------------------------------------------*/
// Anaglyph 3D,  Set from 1 to 9 to balance between minimum and maximum seperation
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define AnaglyphSeperation 9

// Anaglyph Colors,  Set from 1 to 9 to balance between minimum and maximum to match the color of your glasses
//AnaglyphRed goes to the right, AnaglyphGreen and AnaglyphBlue are mixed to the left
// Minimum [ 1 < 2 - 3 - 4 - 5 - 6 - 7 - 8 > 9 ] Maximum
#define AnaglyphRed 1
#define AnaglyphGreen 1
#define AnaglyphBlue 1

/*------------------------------------------------------------------------------
						POST_SHARPEN
------------------------------------------------------------------------------*/
// Controls additional sharpening applied after previous processing. Strength should be max 0.25!
float Sharpen = 0.04;

/*------------------------------------------------------------------------------
						FINAL_LIMITER
------------------------------------------------------------------------------*/
// Controls the strenght of the limiter. 1.000 for default setting
int LimiterStrenght = 1.000; 