/*------------------------------------------------------------------------------
						ANAGLYPH
------------------------------------------------------------------------------*/

float4 AnaglyphPass( float4 colorInput, float2 Tex )
{
	float4 Anaglyph = colorInput;
	float Seperation = 0;
	float RedPower = 0;
	float GreenPower = 0;
	float BluePower = 0;
	// Validating user settings
	if (AnaglyphSeperation < 1 || AnaglyphSeperation > 9) Seperation = 0.0007;
	else Seperation = (AnaglyphSeperation * 0.00050) + 0.0010;
	if (AnaglyphRed < 1 || AnaglyphRed > 9) RedPower = 0.15;
	else RedPower = AnaglyphRed * 0.15;
	if (AnaglyphGreen < 1 || AnaglyphGreen > 9) GreenPower = 0.15;
	else GreenPower = AnaglyphGreen * 0.15;
	if (AnaglyphBlue < 1 || AnaglyphBlue > 9) BluePower = 0.15;
	else BluePower = AnaglyphBlue * 0.15;
	// Setting RGB channel colors
	float red = dot(Anaglyph.rgb, float4(2.55, 0, 0, 0));
	float green = dot(Anaglyph.rgb, float4(0,2.55,0, 0));
	float blue = dot(Anaglyph.rgb, float4(0,0,2.55,0));
	// Setting the RGB channel powers
	float4 red2 = red * RedPower;
	float4 green2 = green * GreenPower;
	float4 blue2 = blue * BluePower;
	// Left Eye (Red)
	float4 LeftEye = tex2D(s0, float2(Tex + float2(-Seperation,0))).rgba;
	red2 = max(red2, LeftEye);
	// Right Eye (Cyan)
	float4 RightEye = tex2D(s0, float2(Tex + float2(Seperation,0))).rgba;
	green2 = max(green2,RightEye);
	blue2 = max(blue2,RightEye);
	float4 cyan = (green2 + blue2) / 2;
	// Combine
	Anaglyph.r = cyan.r;
	Anaglyph.g = red2.g;
	Anaglyph.b = red2.b;
	Anaglyph.a = max(red2.a,cyan.a);
	return Anaglyph;
}