-- Digital Display Fillamounts
--
-- Author Blackburner
-- 21.11.2010
--
-- > Copyright (C) 2011 by Blackburner
--
-- special thanks to Sven777b
-- edited by PeterJ_LS-UK modteam

Display = {};

function Display.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Display:load(savegame)

	self.run = true;
	self.segmentcount = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.display#segmentcount"), 0);
	if self.segmentcount > 0 then
		self.numatpos = {}
		for i=1, self.segmentcount do
			self.numatpos[i] = 0;
		end;
	end;
	if self.segmentcount > 0 then
		self.segment = {};	
		for i=1, self.segmentcount do
			local path = string.format("vehicle.display.segment%d", i);
			self.segment[i] = {};		
			self.segment[i].a = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#a"));
			self.segment[i].b = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#b"));
			self.segment[i].c = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#c"));
			self.segment[i].d = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#d"));
			self.segment[i].e = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#e"));
			self.segment[i].f = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#f"));
			self.segment[i].g = Utils.indexToObject(self.components, getXMLString(self.xmlFile, path .. "#g"));
		end;
	end;
	if self.segmentcount > 0 then
		self.dispseg = {};
		for i=1, self.segmentcount do
			self.dispseg[i] = {};
			self.dispseg[i].a = false;
			self.dispseg[i].b = false;
			self.dispseg[i].c = false;
			self.dispseg[i].d = false;
			self.dispseg[i].e = false;
			self.dispseg[i].f = false;
			self.dispseg[i].g = false;
		end;	
	end;
	self.value = 0;
	self.oldvalue = 0;
	self.converted = false;
	self.valuemax = ((10^(self.segmentcount))-1);
	self.valuemin = 0;
	self.firstrun = true;
	self.displayActive = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.display#index"));
end;

function Display:delete()
end;

function Display:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Display:keyEvent(unicode, sym, modifier, isDown)
end;
 	
function Display:update(dt)

	if self:getFillLevel() == self:getCapacity() then
		self.value = self:getFillLevel();
	else
		self.value = self:getFillLevel() - 1;
	end;

	if self.converted or self.firstrun then
		if self.value ~= self.oldvalue then 
			if self.value > self.valuemax then
				self.value = self.valuemax;
			end; 
			if self.value < self.valuemin then
				self.value = self.valuemin;
			end;
			self.value = math.ceil(self.value);
		end;
		if (self.value ~= self.oldvalue) or self.firstrun then
			self.numatpos[1] = math.floor((self.value - (math.floor(self.value/ 10) * 10)) / 1);
			self.numatpos[2] = math.floor((self.value - (math.floor(self.value/ 100) * 100) - self.numatpos[1]) / 10);
			self.numatpos[3] = math.floor((self.value - (math.floor(self.value/ 1000) * 1000) - self.numatpos[1] - self.numatpos[2]) / 100);
			self.numatpos[4] = math.floor((self.value - (math.floor(self.value/ 10000) * 10000) - self.numatpos[1] - self.numatpos[2] - self.numatpos[3]) / 1000);
			self.numatpos[5] = math.floor((self.value - (math.floor(self.value/ 100000) * 100000) - self.numatpos[1] - self.numatpos[2] - self.numatpos[3] - self.numatpos[4]) / 10000);
			self.numatpos[6] = math.floor((self.value - (math.floor(self.value/ 1000000) * 1000000) - self.numatpos[1] - self.numatpos[2] - self.numatpos[3] - self.numatpos[4] - self.numatpos[5]) / 100000);
			self.numatpos[7] = math.floor((self.value - (math.floor(self.value/ 10000000) * 10000000) - self.numatpos[1] - self.numatpos[2] - self.numatpos[3] - self.numatpos[4] - self.numatpos[5] - self.numatpos[6]) / 1000000);
	
			if self.run then
				for i=1, self.segmentcount do
					if self.numatpos[i] == 0 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = true;	self.dispseg[i].f = true;	self.dispseg[i].g = false;
					elseif self.numatpos[i] == 1 then
						self.dispseg[i].a = false;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = false;	self.dispseg[i].e = false;	self.dispseg[i].f = false;	self.dispseg[i].g = false;
					elseif self.numatpos[i] == 2 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = false;	self.dispseg[i].d = true;	self.dispseg[i].e = true;	self.dispseg[i].f = false;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 3 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = false;	self.dispseg[i].f = false;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 4 then
						self.dispseg[i].a = false;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = false;	self.dispseg[i].e = false;	self.dispseg[i].f = true;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 5 then
						self.dispseg[i].a = true;	self.dispseg[i].b = false;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = false;	self.dispseg[i].f = true;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 6 then
						self.dispseg[i].a = true;	self.dispseg[i].b = false;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = true;	self.dispseg[i].f = true;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 7 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = false;	self.dispseg[i].e = false;	self.dispseg[i].f = false;	self.dispseg[i].g = false;
					elseif self.numatpos[i] == 8 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = true;	self.dispseg[i].f = true;	self.dispseg[i].g = true;
					elseif self.numatpos[i] == 9 then
						self.dispseg[i].a = true;	self.dispseg[i].b = true;	self.dispseg[i].c = true;	self.dispseg[i].d = true;	self.dispseg[i].e = false;	self.dispseg[i].f = true;	self.dispseg[i].g = true;
					end;
				end;
			end;
			self.oldvalue = self.value;
			self.converted = false;
			self.firstrun = false;
		end;
	else
		for i=1, self.segmentcount do
			setVisibility(self.segment[i].a, self.dispseg[i].a);
			setVisibility(self.segment[i].b, self.dispseg[i].b);
			setVisibility(self.segment[i].c, self.dispseg[i].c);
			setVisibility(self.segment[i].d, self.dispseg[i].d);
			setVisibility(self.segment[i].e, self.dispseg[i].e);
			setVisibility(self.segment[i].f, self.dispseg[i].f);
			setVisibility(self.segment[i].g, self.dispseg[i].g);
		end;
		self.converted = true;
	end;
end;

function Display:draw()
end;

function Display:onAttach(attacherVehicle) 
	if self.displayActive ~= nil then
		setVisibility(self.displayActive, true);
	end;
end;
 
function Display:onDetach()
	if self.displayActive ~= nil then
		setVisibility(self.displayActive, true);
	end;
end;
