GLOBAL.setmetatable(GLOBAL.getfenv(1), {__index = function(self, index)
	return GLOBAL.rawget(GLOBAL, index)
end})-- ty penguin

local unpack = unpack or table.unpack or GLOBAL.unpack

local function results(data, ...)
	return type(data) == "function" and {data(...)}  
		or type(data) == "table" and data 
		or {data} 
end 

local function sandwich(func, ante, post)	
	return function(...)
		local results_ante = results(ante, ...)
		if #results_ante > 0 then return unpack(results_ante) end 		
		
		local results_original = results(func, ...)
		
		local results_post = results(post, ...)
		if #results_post > 0 then return unpack(results_post) end 
		
		return unpack(results_original)
	end 
end 

local function overwrite(tabula, name, ante, post)
	if type(tabula) ~= "table" then return end 
	local old = tabula[name]
	tabula[name] = sandwich(old, ante, post)
end 

-- by the wonderful Rafael Lizarralde
local function filum(func, name)-- latin for thread 
	local index = 1
	while true do 
		local current, value = debug.getupvalue(func, index)
		if current ~= name then index = index + 1 else return value, index end 
	end 
end 

local function ariadne(func, ...)
	local station, index = "STATION", "INDEX"
	for _, knot in pairs{...} do 
		if type(func) ~= "function" then return print("UPVALUE HACKER ERROR: knot, ...", knot, ...) end 
		station = func 
		func, index = filum(func, knot)
	end 
	return func, index, station
end 

local function theseus(func, replacement, ...)
	local old, index, station = ariadne(func, ...)
	debug.setupvalue(station, index, replacement)
end 

local function minos(func, ante, post, ...)
	local old, index, station = ariadne(func, ...)
	local replacement = sandwich(func, ante, post)
	debug.setupvalue(station, index, replacement)
end 


--			*			*			*			*			*			*			--

local FILE_ADDRESS = "disable_mods_mod"
local MANUAL_WORKSHOP_SYNC_MOD = "workshop-196046828"

local EXCEPTIONS = {[modname] = true}
for _, mod in pairs{
	2081254154, -- insight, 
	1781410139, -- zoom 
	2672053067, -- my compass zoom 
	196046828, -- manual workshop update 
	2669565839, -- no menu music 
	574636989, -- combined status 
} do EXCEPTIONS["workshop-" .. mod] = true end 

for _, mod in pairs(KnownModIndex:GetModNames()) do
	local info = KnownModIndex:GetModInfo(mod) 
	if info and info.version == "test" then 
		EXCEPTIONS[mod] = true 
	end 
end 

local function RestoreDisabled(self)
	for _, mod in pairs(KnownModIndex:GetModNames()) do 
		KnownModIndex:Disable(mod) 
	end 
	
	TheSim:GetPersistentString(FILE_ADDRESS, function(success, str)
		if not success or not str then return end 
		local data = TrackedAssert("disable mods mod, enable",  json.decode, str)
		for _, mod in pairs(data or {}) do KnownModIndex:Enable(mod) end 
	end)
	
	self.RestoreDisabledButton:Disable()
	self.DisableAllButton:Enable()
	self:RefreshOptions()
end

local function DisableAll(self)
	local list = {}
	for _, mod in pairs(KnownModIndex:GetModNames()) do 
		if KnownModIndex:IsModEnabled(mod) then 
			table.insert(list, mod)
			if not EXCEPTIONS[mod] then KnownModIndex:Disable(mod) end 
		end 
	end 
	TheSim:SetPersistentString(FILE_ADDRESS, json.encode(list), false)
	
	self.DisableAllButton:Disable() 
	self.RestoreDisabledButton:Enable()
	self:RefreshOptions()
end 

local menu = require"widgets/menu"

local function EnableDisableButton()
	for _, mod in pairs(KnownModIndex:GetModNames()) do 
		if KnownModIndex:IsModEnabled(mod) and not EXCEPTIONS[mod] then return true end 
	end 
end 

AddClassPostConstruct("screens/modsscreen", function(self)
	self.DisableAll = DisableAll
	self.RestoreDisabled = RestoreDisabled
	
	self.DisableAllButton = self.mainmenu:AddItem("Disable All", 
		function() self:DisableAll() end, 
		Vector3(0, -285 - 70, 0))
	
	self.RestoreDisabledButton = self.mainmenu:AddItem("Restore", 
		function() self:RestoreDisabled() end, 
		Vector3(170, -280 - 70, 0))
		
	TheSim:GetPersistentString(FILE_ADDRESS, function(success, str)
		if not success or not str then 
			self.RestoreDisabledButton:Disable() 
--		else 
--			local data = TrackedAssert("disable mods mod, enable",  json.decode, str)
--			if type(data) == "table" and #data == 0 then self.DisableAllButton:Disable() end 
		end 
	end)
	
	overwrite(self, "EnableCurrent", function(self)
		self.DisableAllButton:Enable()
	end)
	
	if not EnableDisableButton() then self.DisableAllButton:Disable() end 
end)