local assets=
{
	Asset("ANIM", "anim/windyknife.zip"),
	Asset("ATLAS", "images/inventoryimages/windyknife.xml"),
}

local prefabs = {
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "windyknife", "swap_windyknife")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    if GetWorld().components.worldwind then
        owner.ramp_fn = function()
            inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/sail_stick")
        end
        owner:ListenForEvent("wind_rampup", owner.ramp_fn, GetWorld())
        owner.sail_stick_update = owner:DoPeriodicTask(FRAMES, function()
            GetWorld().components.worldwind:SetOverrideAngle(GetPlayer().Transform:GetRotation())
        end)
    end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
    if GetWorld().components.worldwind then
        if owner.ramp_fn then
            owner:RemoveEventCallback("wind_rampup", owner.ramp_fn, GetWorld())
            owner.ramp_fn = nil
        end
        GetWorld().components.worldwind:SetOverrideAngle(nil)
        owner.sail_stick_update:Cancel()
        owner.sail_stick_update = nil
    end
end

local function onattack(inst, attacker, target, skipsanity)
    local chance = 20
    local damage = inst.components.weapon.damage
    if attacker.components.carneystatus and attacker.components.carneystatus.power == 1 then
        damage = inst.components.weapon.damage*(attacker.components.carneystatus.level*5/200 + 1.25)
    end
    if math.random(1,100) <= chance then
        target.components.combat:GetAttacked(attacker, damage)
        local snap = SpawnPrefab("impact")
        snap.Transform:SetScale(3, 3, 3)
        snap.Transform:SetPosition(target.Transform:GetWorldPosition())
        if target.SoundEmitter ~= nil then
            target.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
        end
    end
    inst.components.windyknifestatus.use = inst.components.finiteuses.current
end

local function repair(inst)
    local repair = inst.components.finiteuses.current/inst.components.finiteuses.total + .2
    if repair >= 1 then repair = 1 end
    inst.components.finiteuses:SetUses(math.floor(repair*inst.components.finiteuses.total))
    inst.components.windyknifestatus.use = inst.components.finiteuses.current
end

local function valuecheck(inst)
    local level = inst.components.windyknifestatus.level
    local amount = math.floor(level/5)
    inst.components.weapon:SetDamage(27+amount)
    inst.components.finiteuses:SetMaxUses(200+level*5)
    inst.components.finiteuses:SetUses(inst.components.windyknifestatus.use)
    local m = math.ceil(15-level/100*15)
    if m <= 1 then m = 1 end
    inst.components.tool:SetAction(ACTIONS.CHOP, 15/m)
    inst.components.tool:SetAction(ACTIONS.HACK, 15/m)
end

local function ItemTradeTest(inst, item)
    if item == nil then
        return false
    elseif item.prefab ~= "goldnugget" then
        return false
    end
    return true
end

local function OnGemGiven(inst, giver, item)
    inst.components.windyknifestatus:DoDeltaLevel(1)
    inst.SoundEmitter:PlaySound("dontstarve/common/telebase_gemplace")
    valuecheck(inst)
    repair(inst)
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    inst.entity:AddSoundEmitter()

    if IsDLCEnabled(CAPY_DLC) then
        MakeInventoryFloatable(inst, "idle_water", "idle")
    end
	
    anim:SetBank("windyknife")
    anim:SetBuild("windyknife")
    anim:PlayAnimation("idle")

    inst:AddTag("windyknife")

    inst:AddComponent("windyknifestatus")
	
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 1)
    inst.components.tool:SetAction(ACTIONS.HACK, 1)
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(27)
    inst.components.weapon:SetOnAttack(onattack)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/windyknife.xml"

	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200+inst.components.windyknifestatus.level*5)
    inst.components.finiteuses:SetUses(inst.components.windyknifestatus.use)
    --inst.components.finiteuses:SetOnFinished(function() inst.components.equippable:Unequip(inst) end)

    inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ItemTradeTest)
    inst.components.trader.onaccept = OnGemGiven

    inst:DoTaskInTime(0.2, function() valuecheck(inst) end)
    
    return inst
end


return Prefab( "windyknife", fn, assets, prefabs) 
