local ICE_COLOUR = { 60/255, 120/255, 255/255 }
local FIRE_COLOUR = { 220/255, 100/255, 0/255 }

local assets =
{
    Asset("ANIM", "anim/deer_fire_charge.zip"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()

    inst.AnimState:SetBank("deer_fire_charge")
    inst.AnimState:SetBuild("deer_fire_charge")
    inst.AnimState:PlayAnimation("blast")
    inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetFinalOffset(1)

    inst.SoundEmitter:PlaySound("dontstarve_DLC002/common/obsidian_wetsizzles")

    inst.entity:AddLight()
    inst.Light:SetColour(197/255,197/255,50/255)
    inst.Light:SetRadius(.7)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetIntensity(.75)
    inst.Light:Enable(true)

    for i=1, 25 do
        inst:DoTaskInTime(i/50, function()
            inst.Light:SetRadius(.7-i/25*.7)
            inst.Light:SetIntensity(.75-i/25*.25)
        end)
    end

    inst:AddTag("FX")

    inst:DoTaskInTime(1, function() inst:Remove() end)

    return inst
end

return Prefab("deer_charge_pst", fn, assets)