local ICE_COLOUR = { 60/255, 120/255, 255/255 }
local FIRE_COLOUR = { 220/255, 100/255, 0/255 }

local assets =
{
    Asset("ANIM", "anim/deer_fire_charge.zip"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()

    inst.AnimState:SetBank("deer_fire_charge")
    inst.AnimState:SetBuild("deer_fire_charge")
    inst.AnimState:PlayAnimation("pre")
    inst.AnimState:PushAnimation("loop")
    inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetFinalOffset(1)

    --inst.SoundEmitter:PlaySound("dontstarve/common/staffteleport")
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_swing")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/torch_LP", "torch")
        
        --inst._fadeframes = 30
        --inst._fadeintensity = .8
        --inst._faderadius = 3
        --inst._fadefalloff = .9
        --inst._fadeinspeed = 1
        --inst._fadeoutspeed = 2

        --inst._fadeframes = 15
        --inst._fadeintensity = .8
        --inst._faderadius = 2
        --inst._fadefalloff = .7
        --inst._fadeinspeed = 3
        --inst._fadeoutspeed = 1

    inst.entity:AddLight()
    inst.Light:SetColour(197/255,197/255,50/255)
    inst.Light:SetRadius(2)
    inst.Light:SetFalloff(0.5)
    inst.Light:SetIntensity(.75)
    inst.Light:Enable(true)

    inst:AddTag("FX")

    return inst
end

return Prefab("deer_charge", fn, assets)