local MakePlayerCharacter = require "prefabs/player_common"
local cst=STRINGS.CARNEYSTRINGS

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/carney.zip" ),
}
local prefabs = {}

local start_inv = {
	"whiteberet",
}

local function value(inst) --计算属性
	local lv = inst.components.carneystatus.level

    --饥饿判定
	local hunger_percent = inst.components.hunger:GetPercent()
	inst.components.hunger.max = 100 + lv*2
	inst.components.hunger:SetPercent(hunger_percent)
	if lv < 100 then
		inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * (100-lv)/100
	else
		inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE * 1/100
	end

	--脑力判定
	local sanity_percent = inst.components.sanity:GetPercent()
	inst.components.sanity.max = 100 + lv*1
	inst.components.sanity:SetPercent(sanity_percent)
	
	--血量判定
	local health_percent = inst.components.health:GetPercent()
	inst.components.health.maxhealth = 100 + lv*1
	inst.components.health:SetPercent(health_percent)

	--最高exp判定
	inst.components.carneystatus.maxexp = lv * 200 + 100

	--速度计算
	inst.components.locomotor.walkspeed = inst.components.carneystatus.speedwalk
	inst.components.locomotor.runspeed = inst.components.carneystatus.speedrun
end

local function levelup(inst)
	inst.components.carneystatus.level = inst.components.carneystatus.level + 1
	inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")
	inst.components.talker:Say("Level UP!")
	value(inst)
	inst.components.hunger:DoDelta(inst.components.hunger.max/5)
end

local function onkilledother(inst, data)
    local victim = data.victim

	if victim.components.freezable or victim:HasTag("monster") and victim.components.health then
		local value = math.ceil(victim.components.health.maxhealth)
		inst.components.carneystatus:DoDeltaExp(value)
	end
	
	if victim.components.lootdropper then
		if victim.components.freezable or victim:HasTag("monster") then
		    if math.random(1, 100) <= inst.components.carneystatus.level then
				victim.components.lootdropper:DropLoot()
	        end
		end
	end
end

local function oneat(inst, food) 
	if food and food.components.edible then
		if food.prefab == "fish"
			or food.prefab == "fish_cooked"
			or food.prefab == "fishsticks"
			or food.prefab == "fishtacos"
			or food.prefab == "eel_cooked"
			or food.prefab == "eel"
			or food.prefab == "unagi"
			or food.prefab == "blubber"
			or food.prefab == "califoniaroll"
			or food.prefab == "fish_med_cooked"
			or food.prefab == "fish_raw"
			or food.prefab == "fish_raw_small"
			or food.prefab == "lobterdinner"
			or food.prefab == "lobsterbisque"
			or food.prefab == "surfnturf"
			or food.prefab == "tropical_fish"
			or food.prefab == "dead_swordfish"
			or food.prefab == "sharkfinsoup"
			or food.prefab == "shark_fin"
			or food.prefab == "lobster_dead"
			or food.prefab == "fish_med"
			then
			inst.components.carneystatus:DoDeltaExp(1000)
			inst.components.talker:Say("exp +1000")
		end
	end
end

local function DoDeltaExpCARNEY(inst)
	if inst.components.carneystatus.exp >= inst.components.carneystatus.maxexp then
		levelup(inst)
		local expnew = inst.components.carneystatus.exp - inst.components.carneystatus.maxexp
		inst.components.carneystatus.exp = 0
		if expnew > 0 then
			inst.components.carneystatus:DoDeltaExp(expnew)
		end
	end
end

local function onwalk(inst)
	if inst.components.locomotor.wantstomoveforward then
		inst.components.carneystatus:DoDeltaExp(1)
	end
end

local function powerready(inst)
	if not inst.components.inventory.equipslots[EQUIPSLOTS.HANDS] then 
		return
	end
	local item = inst.components.inventory.equipslots[EQUIPSLOTS.HANDS].prefab
	if item ~= "boomerang"
	--and item ~= "icestaff"
	--and item ~= "firestaff"
    and item ~= "blowdart_sleep"
    and item ~= "blowdart_fire"
    and item ~= "blowdart_pipe"
    and item ~= "blowdart_yellow"
    and item ~= "blowdart_walrus"
    and item ~= "waterballoon"
    and item ~= "sleepbomb"
    then
	    inst.components.carneystatus.power = 1
		inst.powerfx = SpawnPrefab("deer_charge")
	    inst.powerfx.entity:AddFollower()
	    inst.powerfx.Follower:FollowSymbol(inst.GUID, "swap_object", 30, -150, 0)
	    if item == "umbrella" or item == "grass_umbrella" or item == "palmleaf_umbrella" then
	    	inst.powerfx.Follower:FollowSymbol(inst.GUID, "swap_object", -10, -380, 0)
	    end
	    if item == "shovel" or item == "goldenshovel" or item == "pitchfork" then
	    	inst.powerfx.Follower:FollowSymbol(inst.GUID, "swap_object", 0, 130, 0)
	    end
	    if item == "windyknife" then
	    	inst.powerfx.Follower:FollowSymbol(inst.GUID, "swap_object", 0, -150, 0)
	    end
		local mod = inst.components.carneystatus.level*5/200 + .25
		inst.components.combat:AddDamageModifier("wilson", mod)
	end
end

local function hitother(inst)
	if inst.components.carneystatus.power == 1 and inst.components.combat.target and inst.components.combat.target:IsValid() then
		inst.components.carneystatus.power = 0
		inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound")
	    SpawnPrefab("firesplash_fx").Transform:SetPosition(inst.components.combat.target.Transform:GetWorldPosition())
	    inst.powerfx:Remove()
	    --inst.fxout = SpawnPrefab("deer_fire_burst")
		--inst.fxout.entity:SetParent(inst.entity)
		--inst.fxout.entity:AddFollower()
    	--inst.fxout.Follower:FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
		inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")
		inst.components.combat:AddDamageModifier("wilson", 0)
		if inst.components.hunger.current <= 0 then
        	inst.components.health:DoDelta(-5)
        end
		inst.components.hunger:DoDelta(-5)
	end
end

local function unequip(inst,data)
	if inst.components.carneystatus.power == 1 and data.eslot == EQUIPSLOTS.HANDS then
		inst.powerfx:Remove()
		--inst.fxout = SpawnPrefab("deer_fire_burst")
		--inst.fxout.entity:SetParent(inst.entity)
		--inst.fxout.entity:AddFollower()
    	--inst.fxout.Follower:FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
		inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")
		inst.components.carneystatus.power = 0
		inst.components.combat:AddDamageModifier("wilson", 0)
	end
end

local function spelldone(inst,data)
	if inst.components.carneystatus.spelling == 0 then
	    inst.components.carneystatus.spelling = 1
		if inst.components.hunger.current <= 0 then
			inst.components.health:DoDelta(-15)
		end
		local pt = Point(inst.Transform:GetWorldPosition())
		inst.components.hunger:DoDelta(-15)
	    inst.spellfx1 = SpawnPrefab("moonbase")
	    inst.spellfx1.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    inst.spellfx2 = SpawnPrefab("moonloop")
	    inst.spellfx2.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    --inst.spellfx3 = SpawnPrefab("positronpulse")
	    --inst.spellfx3.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    --inst.spellfx4 = SpawnPrefab("deer_ice_circle")
	    --inst.spellfx4.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    --inst.spellfx5 = SpawnPrefab("deer_ice_flakes")
	    --inst.spellfx5.Transform:SetPosition(inst.Transform:GetWorldPosition())
	    --inst.freshfx = SpawnPrefab("spider")
	    --inst.freshfx.Transform:SetPosition(inst.Transform:GetWorldPosition())
	else
		inst.components.carneystatus.spelling = 0
		SpawnPrefab("lightning").Transform:SetPosition(inst.spellfx1.Transform:GetWorldPosition())
		SpawnPrefab("explode_small").Transform:SetPosition(inst.spellfx1.Transform:GetWorldPosition())
		inst.spellfx1.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
		inst.spellfx1.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
		local pos = Vector3(inst.spellfx1.Transform:GetWorldPosition())
		local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3)
		local amount = -1
		for k,v in pairs(ents) do
    		if v:IsValid()
			and v.components.health
			and v.components.combat
			and not v.components.health:IsDead()
			and not v:HasTag("player")
			and not v:HasTag("wall")
			and not v:HasTag("structure")
			then
				amount = amount + 1
       		end
    	end
		local value = (inst.components.carneystatus.level + 20)*(inst.components.carneystatus.power/4+1)*(1 + amount/10)
		for k,v in pairs(ents) do
    		if v:IsValid()
			and v.components.health
			and v.components.combat
			and not v.components.health:IsDead()
			and not v:HasTag("player")
			and not v:HasTag("wall")
			and not v:HasTag("structure")
			then
       			v.components.combat:GetAttacked(inst, value)
       		end
    	end
    	if inst.components.carneystatus.power == 1 then
			inst.SoundEmitter:PlaySound("dontstarve_DLC001/creatures/bearger/groundpound")
		    SpawnPrefab("firesplash_fx").Transform:SetPosition(inst.spellfx1.Transform:GetWorldPosition())
			inst.powerfx:Remove()
			--inst.fxout = SpawnPrefab("deer_fire_burst")
			--inst.fxout.entity:SetParent(inst.entity)
			--inst.fxout.entity:AddFollower()
	    	--inst.fxout.Follower:FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
			inst.SoundEmitter:PlaySound("dontstarve/common/fireOut")
			inst.components.carneystatus.power = 0
			inst.components.combat:AddDamageModifier("wilson", 0)
			inst.components.hunger:DoDelta(-5)
	        if inst.components.hunger.current <= 0 then
	        	inst.components.health:DoDelta(-5)
	        end
		end
		inst.spellfx1:Remove()
		inst.spellfx2:Remove()
		--inst.spellfx3:Remove()
		--inst.spellfx4:Remove()
		--inst.spellfx5:Remove()
		--inst.freshfx:Remove()
    end
end

local fn = function(inst)
	inst.soundsname = "willow"
	inst:AddTag("carney")
	inst.MiniMapEntity:SetIcon( "carney.tex" )

	inst.components.eater:SetOnEatFn(oneat)

	inst:AddComponent("carneystatus")
	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(100)
	inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE
	
    inst.components.combat:AddDamageModifier("wilson", 0)
	
	inst.components.locomotor.walkspeed = inst.components.carneystatus.speedwalk
	inst.components.locomotor.runspeed = inst.components.carneystatus.speedrun

	inst:ListenForEvent("killed", onkilledother)
    inst:ListenForEvent("onhitother", hitother)
    inst:ListenForEvent("DoDeltaExpCARNEY", DoDeltaExpCARNEY)
    inst:ListenForEvent("locomote", onwalk)
    inst:ListenForEvent("powerready", powerready)
    inst:ListenForEvent("unequip", unequip)
    inst:ListenForEvent("spelldone", spelldone)

	inst:DoTaskInTime(0, function() value(inst) end)

	--闪避
	inst.components.combat.oldAttacked = inst.components.combat.GetAttacked
	function inst.components.combat:GetAttacked(...)
		if inst.components and inst.components.carneystatus and inst.components.carneystatus.miss == 1 then
			local fx = SpawnPrefab("deer_charge_pst")
    		fx.entity:AddFollower()
	    	fx.Follower:FollowSymbol(inst.GUID, "swap_body", 0, 0, 0)
		else
			return inst.components.combat:oldAttacked(...)
		end
	end
end

return MakePlayerCharacter("carney", prefabs, assets, fn, start_inv)