local carneystatus = Class(function(self, inst)
    self.inst = inst
    self.level = 0
    self.exp = 0
    self.expold = 0
    self.expmod = 1
    self.maxexp = 0
    self.miss = 0
    self.missactioning = 0
    self.power = 0
    self.spelling = 0
    self.damagemod = 1
    self.speedwalk = TUNING.WILSON_WALK_SPEED * 1.25
    self.speedrun = TUNING.WILSON_RUN_SPEED * 1.25
end,
nil,
{
})

function carneystatus:OnSave()
    local data = {
        level = self.level,
        exp = self.exp,
    }
    return data
end

function carneystatus:OnLoad(data)
    self.level = data.level or 0
    self.exp = data.exp or 0
end

function carneystatus:DoDeltaExp(delta)
    if delta > 0 then
        self.expold = self.exp
        self.exp = self.exp + delta*self.expmod
    else
        self.expold = self.exp
        self.exp = self.exp + delta
    end
    self.inst:PushEvent("DoDeltaExpCARNEY")
end

function carneystatus:powerready()
	self.inst:PushEvent("powerready")
end

function carneystatus:spelldone()
	self.inst:PushEvent("spelldone")
end

return carneystatus