local GetPlayer = GLOBAL.GetPlayer
local TheInput = GLOBAL.TheInput

local KEY_J = GLOBAL.KEY_J
local J = function(player)
	if not player:HasTag("playerghost") and player.components.carneystatus then
		player.components.talker:Say("lv "..(player.components.carneystatus.level).."  ".."exp "..(player.components.carneystatus.exp).."/"..(player.components.carneystatus.maxexp))
    end
end

local KEY_K = GLOBAL.KEY_K
local K = function(player)
	if not player:HasTag("playerghost") and player.components.carneystatus then
		--player.components.talker:Say()
	end
end

local KEY_R = GLOBAL.KEY_R
local R = function(player)
	if not player:HasTag("playerghost") and player.components.carneystatus then
		local missactioning = player.components.carneystatus.missactioning
		if missactioning == 0 then
			--if not player.sg:HasStateTag("busy") then
				if player.components.driver and player.components.driver.driving == true then
					return
				end
				player.sg:GoToState("idle")
				player.AnimState:PlayAnimation("jumpboat")
				player.AnimState:PushAnimation("land", false)
				player.sg.statemem.action = player.bufferedaction
				--player.sg:SetTimeout(1)
				--GLOBAL.SpawnPrefab("bee_poof_big").Transform:SetPosition(player.Transform:GetWorldPosition())
				
				player.components.carneystatus.missactioning = 1

				local w = player.components.carneystatus.speedwalk
				local r = player.components.carneystatus.speedrun
				player.components.locomotor.walkspeed = w/3*2
				player.components.locomotor.runspeed = r/3*2
				player:DoTaskInTime(.2, function()
					player.SoundEmitter:PlaySound("dontstarve_DLC002/common/coconade_throw")
					for i=1, 9 do
						player.SoundEmitter:PlaySound("dontstarve_DLC002/common/boatjump_whoosh")
					end
					for i=1, 25 do
						player:DoTaskInTime(i/25*.8, function()
							player.components.locomotor.walkspeed = w*(1+(25-i+1)/25)
							player.components.locomotor.runspeed = r*(1+(25-i+1)/25)
						end)
					end
				end)

				player.components.carneystatus.miss = 1
				local level = player.components.carneystatus.level
				if level > 100 then level = 100 end
				player:DoTaskInTime(.4+level/100*.4, function()
					player.components.carneystatus.miss = 0
				end)

				player:DoTaskInTime(.8, function()
					player.components.locomotor.walkspeed = w
					player.components.locomotor.runspeed = r
					if player.components.locomotor.wantstomoveforward then
						player.AnimState:PlayAnimation("run_loop", true)
						player.SoundEmitter:PlaySound("dontstarve_DLC002/common/boatjump_to_land")
					else
						if not player.sg:HasStateTag("busy") and not player.sg:HasStateTag("doing") then
							--player.sg:GoToState("idle")
							player.SoundEmitter:PlaySound("dontstarve_DLC002/common/boatjump_to_land")
						end
					end
				end)

				player:DoTaskInTime(1, function()
					player.components.carneystatus.missactioning = 0
				end)
			--end
		end
	end
end

local KEY_Z = GLOBAL.KEY_Z
local Z = function(player)
	if not player:HasTag("playerghost") and player.components.carneystatus then
		if player.components.carneystatus.power == 0 then
	        player.components.carneystatus:powerready()
	    end
	end
end

local KEY_C = GLOBAL.KEY_C
local C = function(player)
	if not player:HasTag("playerghost") and player.components.carneystatus then
		player.components.carneystatus:spelldone()
	end
end

local carney_handlers = {}
AddPlayerPostInit(function(inst)
	inst:DoTaskInTime(0, function()
		if inst == GetPlayer() then
			if inst.prefab == "carney" then
				carney_handlers[0] = TheInput:AddKeyDownHandler(KEY_J, function()
					local screen = GLOBAL.TheFrontEnd:GetActiveScreen()
            		local IsHUDActive = screen and screen.name == "HUD"
            		if inst:IsValid() and IsHUDActive then
						J(GetPlayer())
					end
				end)
				carney_handlers[1] = TheInput:AddKeyDownHandler(KEY_K, function()
					local screen = GLOBAL.TheFrontEnd:GetActiveScreen()
            		local IsHUDActive = screen and screen.name == "HUD"
            		if inst:IsValid() and IsHUDActive then
						K(GetPlayer())
					end
				end)
				carney_handlers[2] = TheInput:AddKeyDownHandler(KEY_R, function()
					local screen = GLOBAL.TheFrontEnd:GetActiveScreen()
            		local IsHUDActive = screen and screen.name == "HUD"
            		if inst:IsValid() and IsHUDActive then
						R(GetPlayer())
					end
				end)
				carney_handlers[3] = TheInput:AddKeyDownHandler(KEY_Z, function()
					local screen = GLOBAL.TheFrontEnd:GetActiveScreen()
            		local IsHUDActive = screen and screen.name == "HUD"
            		if inst:IsValid() and IsHUDActive then
						Z(GetPlayer())
					end
				end)
				carney_handlers[4] = TheInput:AddKeyDownHandler(KEY_C, function()
					local screen = GLOBAL.TheFrontEnd:GetActiveScreen()
            		local IsHUDActive = screen and screen.name == "HUD"
            		if inst:IsValid() and IsHUDActive then
						C(GetPlayer())
					end
				end)
			else
				carney_handlers[0] = nil
				carney_handlers[1] = nil
				carney_handlers[2] = nil
				carney_handlers[3] = nil
				carney_handlers[4] = nil
			end
		end
	end)
end)