local _G = GLOBAL
local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

local LAN_ = GetModConfigData('Language')
if LAN_ then
	require 'strings_carney_c'
	TUNING.carneylan = true
else
	require 'strings_carney_e'
	TUNING.carneylan = false
end


PrefabFiles = {
	"carney",
	"freshaura",
	"whiteberet",
	"windyknife",
	"nylon",
	"deer_charge",
	"moonbase",
	"moonloop",
	"deer_charge_pst",
    }

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/carney.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/carney.xml" ),

    Asset( "IMAGE", "images/avatars/self_inspect_carney.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_carney.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/carney.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/carney.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/carney_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/carney_silho.xml" ),
	
	Asset( "IMAGE", "images/names_carney.tex" ),
    Asset( "ATLAS", "images/names_carney.xml" ),

    Asset( "IMAGE", "bigportraits/carney.tex" ),
    Asset( "ATLAS", "bigportraits/carney.xml" ),
	
	Asset( "IMAGE", "images/map_icons/carney.tex" ),
	Asset( "ATLAS", "images/map_icons/carney.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_carney.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_carney.xml" ),

	Asset( "IMAGE", "images/avatars/avatar_ghost_carney.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_carney.xml" ),

	Asset( "ATLAS", "images/inventoryimages/whiteberet.xml"),
	Asset( "IMAGE", "images/inventoryimages/whiteberet.tex" ),

	Asset( "ATLAS", "images/inventoryimages/windyknife.xml"),
	Asset( "IMAGE", "images/inventoryimages/windyknife.tex" ),

	Asset( "ATLAS", "images/inventoryimages/nylon.xml"),
	Asset( "IMAGE", "images/inventoryimages/nylon.tex" ),

	Asset( "ATLAS", "images/hud/carneytab.xml"),
	Asset( "IMAGE", "images/hud/carneytab.tex" ),
}

AddStategraphPostInit("wilson", function(self)
    for key,value in pairs(self.states) do
        if value.name == 'run_stop' then
            local original_run_stop_onenter = self.states[key].onenter
            self.states[key].onenter = function(inst)
            	if inst.components.carneystatus and inst.components.carneystatus.miss == 1 then
            		inst.components.locomotor:Stop()
                else
                    original_run_stop_onenter(inst)
                end
            end
        end
        if value.name == 'run_start' then
            local original_run_start_onenter = self.states[key].onenter
            self.states[key].onenter = function(inst)
            	if inst.components.carneystatus and inst.components.carneystatus.miss == 1 then
            		inst.components.locomotor:RunForward()
            		if inst.sg.mem.footsteps then inst.sg.mem.footsteps = 0 end
                else
                    original_run_start_onenter(inst)
                end
            end
        end
        if value.name == 'run' then
            local original_run_onenter = self.states[key].onenter
            self.states[key].onenter = function(inst)
            	if inst.components.carneystatus and inst.components.carneystatus.miss == 1 then
            		inst.components.locomotor:RunForward()
                else
                    original_run_onenter(inst)
                end
            end
        end
        if value.name == 'funnyidle' then
            local original_funnyidle_onenter = self.states[key].onenter
            self.states[key].onenter = function(inst)
            	if inst.components.carneystatus and inst.components.carneystatus.miss == 1 then
                else
                    original_funnyidle_onenter(inst)
                end
            end
        end
--		if value.name == 'attack' then
--			self.states[key].timeline = {
--				GLOBAL.TimeEvent(8*GLOBAL.FRAMES, function(inst)
--	            	inst.components.combat:DoAttack(inst.sg.statemem.target)
--	            	inst.sg:RemoveStateTag("abouttoattack")
--	        	end),
--	        	GLOBAL.TimeEvent(10*GLOBAL.FRAMES, function(inst)
--	        		local weapon = inst.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.HANDS)
--	        		if weapon and weapon:HasTag("windyknife") then
--	        			inst.sg:RemoveStateTag("busy")
--	        			inst.sg:RemoveStateTag("attack")
--	        		end
--	        	end),
--	            GLOBAL.TimeEvent(12*GLOBAL.FRAMES, function(inst) 
--					inst.sg:RemoveStateTag("busy")
--				end),				
--	            GLOBAL.TimeEvent(13*GLOBAL.FRAMES, function(inst)
--					if not inst.sg.statemem.slow then
--						inst.sg:RemoveStateTag("attack")
--					end
--	            end),
--	            GLOBAL.TimeEvent(24*GLOBAL.FRAMES, function(inst)
--					if inst.sg.statemem.slow then
--						inst.sg:RemoveStateTag("attack")
--					end
--	            end),
--	        }
--		end
	end
end)

local function morepick(inst)
	inst.components.pickable.Pick = function(self, picker)
	if picker.components.carneystatus then
		local value = math.ceil(picker.components.carneystatus.level/20)
		local chance = (picker.components.carneystatus.level - math.floor(picker.components.carneystatus.level/20)*20)/20
		if chance ~= 0 then
			if math.random() <= chance then
				value = value + 1
			end
		else
			value = value + 1
		end
		self.numtoharvest = self.numtoharvest*value
	end
    if self.canbepicked and self.caninteractwith then

		if self.transplanted then
			if self.cycles_left ~= nil then
				self.cycles_left = self.cycles_left - 1
			end
		end
		
		local loot = nil
        if picker and picker.components.inventory and self.product then
            loot = GLOBAL.SpawnPrefab(self.product)

            if loot then
	            if self.numtoharvest > 1 and loot.components.stackable then
	            	loot.components.stackable:SetStackSize(self.numtoharvest)
	            end
		        picker:PushEvent("picksomething", {object = self.inst, loot= loot})
                picker.components.inventory:GiveItem(loot, nil, GLOBAL.Vector3(TheSim:GetScreenPos(self.inst.Transform:GetWorldPosition())))
            end
        end
        
        if self.onpickedfn then
            self.onpickedfn(self.inst, picker, loot)
        end
        
        self.canbepicked = false
        
        if not self.paused and self.regentime and (self.cycles_left == nil or self.cycles_left > 0) then
			self.task = self.inst:DoTaskInTime(self.regentime, OnRegen, "regen")
			self.targettime = GLOBAL.GetTime() + self.regentime
		end
        
        self.inst:PushEvent("picked", {picker = picker, loot = loot})
    end
	end
end

local list = {
	"grass",
	"sapling",
	"reeds",
	"flower",
	"carrot_planted",
	"flower_evil",
	"berrybush",
	"berrybush2",
	"cactus",
	--"oasis_cactus",
	--"cactus_flower",
	"red_mushroom",
	"green_mushroom",
	"blue_mushroom",
	"cave_fern",
	"cave_banana_tree",
	--"flower_rose",
	"lichen",
	"marsh_bush",
	"flower_cave",
	"flower_cave_double",
	"flower_cave_triple",
	"limpetrock",
	"seaweed_planted",
	"mussel_farm",
	"grass_water",
	"seashell_beached",
	"sweet_potato_planted",
	"coffeebush",
}
for i=1, #list do
	AddPrefabPostInit(list[i], function(inst)
		morepick(inst)
	end)
end

local function carneytab(inst)
	local carneytab = { str = STRINGS.CARNEYTAB, sort = 999, icon = "carneytab.tex", icon_atlas = "images/hud/carneytab.xml" }
	inst.components.builder:AddRecipeTab(carneytab)

	local whiteberet = Recipe("whiteberet", {Ingredient("rope", 2), Ingredient("silk", 6)}, 
	carneytab, {SCIENCE=0} )
	whiteberet.atlas = "images/inventoryimages/whiteberet.xml"

	local windyknife = Recipe("windyknife", {Ingredient("cane", 1), Ingredient("flint", 6)}, 
	carneytab, {SCIENCE=0} )
	windyknife.atlas = "images/inventoryimages/windyknife.xml"

	local whiteberet = Recipe("nylon", {Ingredient("silk", 18), Ingredient("cutgrass", 6), Ingredient("twigs", 6)}, 
	carneytab, {SCIENCE=0} )
	whiteberet.atlas = "images/inventoryimages/nylon.xml"
end

STRINGS.CHARACTERS.CARNEY = require "speech_wilson"

table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "carney")

AddMinimapAtlas("images/map_icons/carney.xml")
AddModCharacter("carney")

AddPrefabPostInit("carney", carneytab)

modimport("scripts/carney_util/carney_util.lua")