local assets=
{    
	Asset("ANIM", "anim/suwado.zip"),
    Asset("ANIM", "anim/swap_suwado.zip"),
    Asset("ATLAS", "images/inventoryimages/suwado.xml"),
    Asset("IMAGE", "images/inventoryimages/suwado.tex"),
}

	prefabs = {}
	
	-- this function will be called when our tool breaks
local function onfinished(inst) 
    inst:Remove()
end
	
local function fn()  
	
	local function OnEquip(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_suwado", "suwado")
		owner.AnimState:Show("ARM_carry")
		owner.AnimState:Hide("ARM_normal")
		
		if owner and not owner:HasTag("slasher") then
		owner:AddTag("slasher")
		end
    end    
	
	local function OnUnequip(inst, owner)
		owner.AnimState:Hide("ARM_carry")
		owner.AnimState:Show("ARM_normal")
		
		if owner and owner:HasTag("slasher") then
		owner:RemoveTag("slasher")
		end
		
    end    
	
	local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
	
	anim:SetBank("suwado")
    anim:SetBuild("suwado")
    anim:PlayAnimation("idle")
	
	inst.entity:SetPristine()
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddTag("sharp")
	inst:AddComponent("finiteuses")  --- durability
    inst.components.finiteuses:SetMaxUses(1000)
    inst.components.finiteuses:SetUses(1000)    
    inst.components.finiteuses:SetOnFinished(inst.Remove)

    inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(50)

	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 1.5)
	inst.components.tool:SetAction(ACTIONS.MINE, 1)
	--it loses durability for chopping and mining
	inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 2) 
	inst.components.finiteuses:SetConsumption(ACTIONS.MINE, 5)

    inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "suwado"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/suwado.xml"

	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	--inst.components.inventoryitem.keepondeath = true
	
	MakeHauntableLaunch(inst)
	
	local oldOnPickup = inst.components.inventoryitem.OnPickup
	inst.components.inventoryitem.OnPickup = function(self, pickupguy)
		if pickupguy.prefab == "inosuke" then
			if not self.inst.itemowner then
				self.inst.itemowner = pickupguy
			end
			if pickupguy == self.inst.itemowner then
				oldOnPickup(self, pickupguy)
			elseif pickupguy.components.talker then
				pickupguy.components.talker:Say("That sword is not mine.")
			end
		elseif pickupguy.components.talker then
			pickupguy.components.talker:Say("I cannot wield that.")
		end
	end
	
    return inst
	
end

	

return  Prefab("common/inventory/suwado", fn, assets, prefabs)