local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = {}

-- Custom starting inventory
local start_inv = {
	"boarhat",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when not a ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "inosuke_speed_mod", 1.0)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "inosuke_speed_mod")
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

--Positive sanity aura from pigmen
local function sanityfn(inst)
	local x, y, z = inst.Transform:GetWorldPosition()
	local ents = TheSim:FindEntities(x, y, z, 20, {"pigman"})
	local delta = 0
	for k, v in pairs(ents) do
		local distsq = math.max(inst:GetDistanceSqToInst(v), 1)
		delta = delta + TUNING.SANITYAURA_MED / distsq
	end
	return delta
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "inosuke.tex" )
	-- Lets him chop wood fast like Woodie
	inst:AddTag("woodcutter")
    --Add this tag in order to craft custom items
	inst:AddTag("boarbuilder")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "woodie"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats
	
	local old_abs = inst.components.health.absorb
	inst.components.health:SetMaxHealth(175)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	inst.Transform:SetScale(1.3,1.3,1.3)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	--gain sanity when attacking creatures listed
	local function OnHit(target,inst)
        if target and target.prefab then
            if target.prefab == "deerclops" then
                inst.components.sanity:DoDelta(2)
            end
            if target.prefab == "leif" then
                inst.components.sanity:DoDelta(1)
            end
			if target.prefab == "leif_sparse" then
                inst.components.sanity:DoDelta(1)
            end
			if target.prefab == "spiderqueen" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "minotaur" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "moose" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "malbatross" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "bearger" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "dragonfly" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "toadstool" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "beequeen" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "klaus" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "stalker" then
                inst.components.sanity:DoDelta(2)
            end
			if target.prefab == "antlion" then
                inst.components.sanity:DoDelta(2)
            end
			
        end
    end
    inst:ListenForEvent( "onhitother", function(inst,data) OnHit(data.target,inst) end )
	
	
	--Blocks the use of armor
	local _Equip = inst.components.inventory.Equip	

	inst.components.inventory.Equip = function(self, item, old_to_active)
		if not item or not item.components.equippable or not item:IsValid() then
			return		
		end		
		
		if item.components.equippable.equipslot == EQUIPSLOTS.HEAD and item.prefab ~= "boarhat" and item.components.armor
		or item.components.equippable.equipslot == EQUIPSLOTS.BODY and item.prefab ~= "sworda" and item.components.armor then		
			self:DropItem(item)
			self:GiveItem(item)
			if inst and inst.components.talker then
				inst.components.talker:Say("I dont need armor!!")
			end
			return
		end		
		
		return _Equip(self, item, old_to_active)	
	end
	
	-- Gives Sanity when in range of Pigmen
	
	inst.components.sanity.custom_rate_fn = sanityfn
	
end

return MakePlayerCharacter("inosuke", prefabs, assets, common_postinit, master_postinit, start_inv)
