local assets=
{ 
    Asset("ANIM", "anim/boarhat.zip"),   

    Asset("ATLAS", "images/inventoryimages/boarhat.xml"),
    Asset("IMAGE", "images/inventoryimages/boarhat.tex"),
}


local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "boarhat", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
		owner.AnimState:Hide("HEADBASE")
        owner.AnimState:Hide("HEADBASE_HAT")
        print('A')
        if owner:HasTag("player") then
            print('B')
            owner.AnimState:Hide("HEADBASE")
            owner.AnimState:Hide("HEADBASE_HAT")
        end
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

        if owner:HasTag("player") then
            owner.AnimState:Show("HEADBASE")
            owner.AnimState:Hide("HEADBASE_HAT")
        end
end
	
local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
        
    inst:AddTag("hat")
	
    anim:SetBank("boarhat")
    anim:SetBuild("boarhat")
    anim:PlayAnimation("idle")

		
	inst.entity:SetPristine()
	if not TheWorld.ismastersim then
		return inst
	end
		   
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "boarhat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/boarhat.xml"
	
	
	--Makes it an Armor 
	--eg InitCondition("damage it can take", "percentage blocked")
	inst:AddComponent("armor")
    inst.components.armor:InitCondition("2500", "0.3")
	
	--Gives a small amount of insulation
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_SMALL)
	
	local oldOnPickup = inst.components.inventoryitem.OnPickup
	inst.components.inventoryitem.OnPickup = function(self, pickupguy)
		if pickupguy.prefab == "inosuke" then
			if not self.inst.itemowner then
				self.inst.itemowner = pickupguy
			end
			if pickupguy == self.inst.itemowner then
				oldOnPickup(self, pickupguy)
			elseif pickupguy.components.talker then
				pickupguy.components.talker:Say("That hat is not mine.")
			end
		elseif pickupguy.components.talker then
			pickupguy.components.talker:Say("I don't need that.")
		end
	end
	
	MakeHauntableLaunch(inst)
	
    return inst
end



return  Prefab("common/inventory/boarhat", fn, assets, prefabs)