PrefabFiles = {
	"inosuke",
	"inosuke_none",
	"boarhat",
	"sworda",
	"suwado",
}
GetPlayer = GLOBAL.GetPlayer

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/inosuke.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/inosuke.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/inosuke.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/inosuke.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/inosuke_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/inosuke_silho.xml" ),

    Asset( "IMAGE", "bigportraits/inosuke.tex" ),
    Asset( "ATLAS", "bigportraits/inosuke.xml" ),
	
	Asset( "IMAGE", "images/map_icons/inosuke.tex" ),
	Asset( "ATLAS", "images/map_icons/inosuke.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_inosuke.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_inosuke.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_inosuke.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_inosuke.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_inosuke.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_inosuke.xml" ),
	
	Asset( "IMAGE", "images/names_inosuke.tex" ),
    Asset( "ATLAS", "images/names_inosuke.xml" ),
	
	Asset( "IMAGE", "images/names_gold_inosuke.tex" ),
    Asset( "ATLAS", "images/names_gold_inosuke.xml" ),
	
	Asset( "IMAGE", "images/boartab/boartab.tex" ),
	Asset( "ATLAS", "images/boartab/boartab.xml" ),
	
	--Character Items
	
	Asset("ATLAS", "images/inventoryimages/boarhat.xml"),
    Asset("IMAGE", "images/inventoryimages/boarhat.tex"),
	
	
	Asset("ATLAS", "images/inventoryimages/sworda.xml"),
    Asset("IMAGE", "images/inventoryimages/sworda.tex"),
	
	Asset("ATLAS", "images/inventoryimages/suwado.xml"),
    Asset("IMAGE", "images/inventoryimages/suwado.tex"),
}

AddMinimapAtlas("images/map_icons/inosuke.xml")

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH


-- The character select screen lines
STRINGS.CHARACTER_TITLES.inosuke = "The Beast Breathing\n Demon Slayer"
STRINGS.CHARACTER_NAMES.inosuke = "Inosuke"
STRINGS.CHARACTER_DESCRIPTIONS.inosuke = "*Proud and Overconfident\n*Great Fighter\n*Overconfident"
STRINGS.CHARACTER_QUOTES.inosuke = "\"(Maniacal laughter) Better watch out! Cuz ready or not, HERE I COME!!\""

-- Custom speech strings
STRINGS.CHARACTERS.INOSUKE = require "speech_inosuke"

-- The character's name as appears in-game 
STRINGS.NAMES.INOSUKE = "Inosuke"
STRINGS.SKIN_NAMES.inosuke_none = "Inosuke"

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("inosuke", "MALE")

--Boar Hat
STRINGS.NAMES.BOARHAT = "Inosuke's Boar Hat"
GLOBAL.STRINGS.RECIPE_DESC.BOARHAT = "Protects your noggin \n Little warmth"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BOARHAT= "It's a boar's head..."

--First Sword
GLOBAL.STRINGS.NAMES.SUWADO = "Sword"
GLOBAL.STRINGS.RECIPE_DESC.SUWADO = "A strong sword"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUWADO = "This Sword has seen many battles... AND A ROCK!"

--Second Sword
GLOBAL.STRINGS.NAMES.SWORDA = "Second Sword"
GLOBAL.STRINGS.RECIPE_DESC.SWORDA = "Increases strength \n Protects you"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SWORDA = "Pig ASSAULT!!"

AddComponentPostInit("combat", function(Combat)
	local OldCalcDamage = Combat.CalcDamage
	Combat.CalcDamage = function(self, target, weapon, ...)
		local old_dmg = nil
		if target and self.inst:HasTag("boarsword") and self.inst:HasTag("slasher") and self.inst.components.combat.damagemultiplier ~= nil then
			old_dmg = self.inst.components.combat.damagemultiplier
			self.inst.components.combat.damagemultiplier = old_dmg+0.9
		elseif target and self.inst:HasTag("boarsword") and self.inst.components.combat.damagemultiplier ~= nil then
			old_dmg = self.inst.components.combat.damagemultiplier
			self.inst.components.combat.damagemultiplier = old_dmg+0.5
		elseif target and self.inst:HasTag("boarsword") and self.inst.components.combat.damagemultiplier == nil then
			old_dmg = 1
			self.inst.components.combat.damagemultiplier = old_dmg+0.5
		end
		local ret = OldCalcDamage(self, target, weapon, ...)
		if old_dmg then
			self.inst.components.combat.damagemultiplier = old_dmg
		end
		return ret
	end
end)

----------------------------------------------------------------------------------------
-- Custom Recipe Tab Info
local boartab = AddRecipeTab("Boar Tab", 998, "images/boartab/boartab.xml", "boartab.tex", "boarbuilder")


-- Add Recipes

local boarhat = Ingredient( "boarhat", 1 )
boarhat.atlas = "images/inventoryimages/boarhat.xml"
local boarhat_recipe = AddRecipe("boarhat", { Ingredient("pigskin", 5), Ingredient("rope", 5)}, boartab, TECH.NONE, nil, nil, nil, nil, "boarbuilder", "images/inventoryimages/boarhat.xml") 

local suwado = Ingredient( "suwado", 1 )
suwado.atlas = "images/inventoryimages/suwado.xml"
local suwado_recipe = AddRecipe("suwado", { Ingredient("marble", 5), Ingredient("cutstone", 10), Ingredient("charcoal",10), Ingredient("flint",20)}, boartab, TECH.NONE, nil, nil, nil, nil, "boarbuilder", "images/inventoryimages/suwado.xml") 

local sworda = Ingredient( "sworda", 1 )
sworda.atlas = "images/inventoryimages/sworda.xml"
local sworda_recipe = AddRecipe("sworda", { Ingredient("marble", 10), Ingredient("cutstone", 33), Ingredient("charcoal",25), Ingredient("flint",50)}, boartab, TECH.NONE, nil, nil, nil, nil, "boarbuilder", "images/inventoryimages/sworda.xml") 

